/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.authentication.microsoftGraphApi;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;

public class MicrosoftGraphApiConnectionResult {
    private boolean success;
    private List<String> successMessages;
    private List<String> warningMessages;
    private List<String> errorMessages;

    public MicrosoftGraphApiConnectionResult(boolean success, String successMessage, String warningMessage, String errorMessage) {
        this(success, successMessage == null ? Collections.emptyList() : Collections.singletonList(successMessage), warningMessage == null ? Collections.emptyList() : Collections.singletonList(warningMessage), errorMessage == null ? Collections.emptyList() : Collections.singletonList(errorMessage));
    }

    public static MicrosoftGraphApiConnectionResult success() {
        return new MicrosoftGraphApiConnectionResult(true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static MicrosoftGraphApiConnectionResult success(String message) {
        return new MicrosoftGraphApiConnectionResult(true, message, null, null);
    }

    public static MicrosoftGraphApiConnectionResult success(List messages) {
        return new MicrosoftGraphApiConnectionResult(true, messages, Collections.emptyList(), Collections.emptyList());
    }

    public static MicrosoftGraphApiConnectionResult warning(String message) {
        return new MicrosoftGraphApiConnectionResult(true, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(message));
    }

    public static MicrosoftGraphApiConnectionResult warning(List messages) {
        return new MicrosoftGraphApiConnectionResult(true, Collections.emptyList(), Collections.emptyList(), messages);
    }

    public static MicrosoftGraphApiConnectionResult error(String message) {
        return new MicrosoftGraphApiConnectionResult(false, null, null, message);
    }

    public static MicrosoftGraphApiConnectionResult error(List messages) {
        return new MicrosoftGraphApiConnectionResult(false, Collections.emptyList(), messages, Collections.emptyList());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<String> getSuccessMessages() {
        return this.successMessages;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    @ConstructorProperties(value={"success", "successMessages", "warningMessages", "errorMessages"})
    public MicrosoftGraphApiConnectionResult(boolean success, List<String> successMessages, List<String> warningMessages, List<String> errorMessages) {
        this.success = success;
        this.successMessages = successMessages;
        this.warningMessages = warningMessages;
        this.errorMessages = errorMessages;
    }
}

