/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import java.security.MessageDigest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Encrypter {
    private static Logger log = LoggerFactory.getLogger(Encrypter.class);

    protected String digest(String digestAlgorithm, String sourceMessage, String digestSalt) {
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(digestSalt.getBytes());
            byte[] digestedMessage = md.digest(sourceMessage.getBytes());
            return this.toString(digestedMessage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Boolean isKeyCorrect(String key, String digestAlgorithm, String id, String digestSalt) {
        try {
            if (StringUtils.isNotBlank((String)key)) {
                if (this.isCodeCorrect(key, digestAlgorithm, id, digestSalt).booleanValue()) {
                    return true;
                }
            } else {
                log.info("Empty key for id [{}].", (Object)id);
            }
        }
        catch (Exception e) {
            log.error("Key validation error : ", (Throwable)e);
        }
        return false;
    }

    private Boolean isCodeCorrect(String codeToValidate, String digestAlgorithm, String sourceMessage, String digestSalt) {
        String codePattern = this.digest(digestAlgorithm, sourceMessage, digestSalt);
        return codePattern.equals(codeToValidate);
    }

    private String toString(byte[] digestedMessage) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < digestedMessage.length; ++i) {
            int current = digestedMessage[i];
            for (int j = 0; j < 2; ++j) {
                int nibble = 0xF & (1 == j ? current : current >> 4);
                buffer.append(Character.forDigit(nibble, 16));
            }
        }
        return buffer.toString();
    }
}

