/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.eventaction;

import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.workflow.component.ContextVariable;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public final class Event {
    private final String name;
    private final LocalizedString description;
    private final List<ContextVariable<?>> properties;

    public String getDescription() {
        return LocalizedString.getOrEmpty(this.description);
    }

    @ConstructorProperties(value={"name", "description", "properties"})
    public Event(String name, LocalizedString description, List<ContextVariable<?>> properties) {
        this.name = name;
        this.description = description;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public List<ContextVariable<?>> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<ContextVariable<?>> this$properties = this.getProperties();
        List<ContextVariable<?>> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<ContextVariable<?>> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "Event(name=" + this.getName() + ", description=" + this.getDescription() + ", properties=" + this.getProperties() + ")";
    }

    public static class EventBuilder {
        private String name;
        private String description;
        private final List<Property> properties = new ArrayList<Property>();

        public EventBuilder property(String id, String name, String description, Type<?> type) {
            this.properties.add(new Property(id, name, description, type));
            return this;
        }

        public Event build(Translator translator) {
            return new Event(this.name, this.translated(this.description, translator), this.properties.stream().map(property -> new ContextVariable(property.id, this.translated(property.name, translator), this.translated(property.description, translator), property.type, false)).collect(Collectors.toList()));
        }

        private LocalizedString translated(String key, Translator translator) {
            return StringUtils.hasText((String)key) ? new LocalizedString(key, translator, new Object[0]) : null;
        }

        public EventBuilder name(String name) {
            this.name = name;
            return this;
        }

        public EventBuilder description(String description) {
            this.description = description;
            return this;
        }

        public static final class Property {
            private final String id;
            private final String name;
            private final String description;
            private final Type<?> type;

            @ConstructorProperties(value={"id", "name", "description", "type"})
            public Property(String id, String name, String description, Type<?> type) {
                this.id = id;
                this.name = name;
                this.description = description;
                this.type = type;
            }

            public String id() {
                return this.id;
            }

            public String name() {
                return this.name;
            }

            public String description() {
                return this.description;
            }

            public Type<?> type() {
                return this.type;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Property)) {
                    return false;
                }
                Property other = (Property)o;
                String this$id = this.id();
                String other$id = other.id();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$name = this.name();
                String other$name = other.name();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$description = this.description();
                String other$description = other.description();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                Type<?> this$type = this.type();
                Type<?> other$type = other.type();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.id();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $name = this.name();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $description = this.description();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                Type<?> $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public String toString() {
                return "Event.EventBuilder.Property(id=" + this.id() + ", name=" + this.name() + ", description=" + this.description() + ", type=" + this.type() + ")";
            }
        }
    }
}

