/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.translation;

import com.suncode.pwfl.translation.AbstractTranslator;
import com.suncode.pwfl.translation.NoTranslationException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.ResourceLoader;

public class PropertiesTranslator
extends AbstractTranslator {
    private final BundleExposingMessageSource messageSource = new BundleExposingMessageSource();

    public PropertiesTranslator() {
        this.messageSource.setFallbackToSystemLocale(false);
        this.messageSource.setDefaultEncoding("UTF-8");
    }

    public void setBasename(String basename) {
        this.messageSource.setBasename(basename);
    }

    public void setBasenames(String ... basenames) {
        this.messageSource.setBasenames(basenames);
    }

    public void setDefaultEncoding(String charset) {
        this.messageSource.setDefaultEncoding(charset);
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.messageSource.setResourceLoader(resourceLoader);
    }

    @Override
    protected String resolveMessage(String key, Locale locale, Object ... args) throws NoTranslationException {
        try {
            return this.messageSource.getMessage(key, args, locale);
        }
        catch (NoSuchMessageException e) {
            throw new NoTranslationException(key, locale);
        }
    }

    @Override
    public Map<String, String> getMessages(Locale locale) {
        Properties properties = this.messageSource.getProperties(locale);
        HashMap<String, String> messages = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            messages.put(key, properties.getProperty(key));
        }
        return messages;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PropertiesTranslator) {
            PropertiesTranslator other = (PropertiesTranslator)obj;
            return new EqualsBuilder().append((Object)this.messageSource, (Object)other.messageSource).appendSuper(super.equals(other)).isEquals();
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.messageSource).appendSuper(super.hashCode()).toHashCode();
    }

    private static class BundleExposingMessageSource
    extends ReloadableResourceBundleMessageSource {
        private BundleExposingMessageSource() {
        }

        public Properties getProperties(Locale locale) {
            return super.getMergedProperties(locale).getProperties();
        }
    }
}

