/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WfDocument {
    private Long id;
    private Date expirationDate;
    private boolean expired;
    private WfFile file;
    private WfFileVersion version;
    private List<IndexInfo> indexes = new ArrayList<IndexInfo>();
    private Long documentClassId;
    public static final String JOIN_DOC_CLASS = "documentClass";

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public WfFile getFile() {
        return this.file;
    }

    public void setFile(WfFile file) {
        this.file = file;
    }

    public WfFileVersion getVersion() {
        return this.version;
    }

    public void setVersion(WfFileVersion version) {
        this.version = version;
    }

    public List<IndexInfo> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<IndexInfo> indexes) {
        this.indexes = indexes;
    }

    public void addIndex(IndexInfo indexInfo) {
        this.indexes.add(indexInfo);
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public IndexInfo getIndexById(Long indexId) {
        for (IndexInfo ii : this.indexes) {
            if (!ii.getId().equals(indexId)) continue;
            return ii;
        }
        return null;
    }

    public IndexInfo getIndexByName(String indexName) {
        for (IndexInfo ii : this.indexes) {
            if (!ii.getName().equals(indexName)) continue;
            return ii;
        }
        return null;
    }

    public Long getDocumentClassId() {
        return this.documentClassId;
    }

    public void setDocumentClassId(Long documentClassId) {
        this.documentClassId = documentClassId;
    }

    public void setIndexValue(String indexName, Object indexValue) {
        IndexInfo idx = this.getIndexByName(indexName);
        if (idx == null) {
            throw new IllegalArgumentException("Nie znaleziono indeksu o nazwie: " + indexName);
        }
        idx.setValue(indexValue);
    }

    public Object getIndexValue(String indexName) {
        IndexInfo idx = this.getIndexByName(indexName);
        return idx.getValue();
    }

    public void setIndexValue(Long indexId, Object indexValue) {
        IndexInfo idx = this.getIndexById(indexId);
        if (idx == null) {
            throw new IllegalArgumentException("Nie znaleziono indeksu o id: " + indexId);
        }
        idx.setValue(indexValue);
    }

    public Object getIndexValue(Long indexId) {
        IndexInfo idx = this.getIndexById(indexId);
        return idx.getValue();
    }
}

