/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum IndexType {
    STRING("string"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }
    }
    ,
    LONG("integer"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Long.valueOf(value);
        }
    }
    ,
    LIST("list"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return value;
        }
    }
    ,
    DATE("date"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            value = IndexType.normalizeDate(value, DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
            return new LocalDate((Object)value);
        }
    }
    ,
    DATETIME("dateTime"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            try {
                value = IndexType.normalizeDate(value, DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
                return LocalDateTime.parse((String)value, (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e) {
                return value;
            }
        }
    }
    ,
    DOUBLE("float"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Double.valueOf(value);
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        public Object parse(String value) {
            if (StringUtils.isBlank((String)value)) {
                return null;
            }
            return Boolean.valueOf(value);
        }
    };

    private String value;
    private static final List<DateTimeFormatter> INPUT_FORMATTERS;

    private IndexType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static IndexType getType(String name) {
        for (IndexType indexType : IndexType.values()) {
            if (!indexType.value.equals(name)) continue;
            return indexType;
        }
        throw new RuntimeException("No such type value: " + name);
    }

    public abstract Object parse(String var1);

    private static String normalizeDate(String input, DateTimeFormatter outputFormat) {
        for (DateTimeFormatter formatter : INPUT_FORMATTERS) {
            try {
                LocalDateTime dateTime = formatter.parseLocalDateTime(input);
                return dateTime.toString(outputFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("Nieobs\u0142ugiwany format daty: " + input);
    }

    static {
        INPUT_FORMATTERS = Arrays.asList(DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS"), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm"), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH"), DateTimeFormat.forPattern((String)"yyyy-MM-dd"));
    }
}

