/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import com.suncode.pwfl.cache.CacheFactory;
import com.suncode.pwfl.cache.PlusWorkflowCache;
import com.suncode.pwfl.cache.SystemCacheId;
import com.suncode.pwfl.cache.config.InMemoryCacheConfig;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserIdCache {
    private static final Logger log = LoggerFactory.getLogger(UserIdCache.class);
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private CacheFactory cacheFactory;
    private PlusWorkflowCache<String, Long> cache;

    @PostConstruct
    private void init() {
        InMemoryCacheConfig<String, Long> cacheConfig = InMemoryCacheConfig.builder().maximumSize(1000L).expireAfterRead(Duration.ofMinutes(5L)).loadFunction(this::loadUserIdByUsername).build();
        this.cache = this.cacheFactory.createInMemoryCache(SystemCacheId.USER_ID_CACHE, cacheConfig);
    }

    private Long loadUserIdByUsername(String username) {
        User user = this.userFinder.findByUserName(username, new String[0]);
        if (Objects.isNull(user)) {
            log.error("User not found in database: " + username);
            return 0L;
        }
        return user.getObjectId();
    }

    public Long getUserIdByUsername(String username) {
        return this.cache.get(username);
    }

    public String getUsernameById(Long id) {
        return this.cache.asMap().entrySet().stream().filter(entry -> id.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElseGet(() -> {
            User user = (User)this.userFinder.get(id);
            if (user != null) {
                this.cache.put(user.getUserName(), id);
                return user.getUserName();
            }
            throw new UserNotFoundException();
        });
    }
}

