/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.activity;

import com.google.common.collect.Sets;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserGroup;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="pm_activityredirection")
@SequenceGenerator(name="pm_activityredirection_id_seq", sequenceName="pm_activityredirection_id_seq")
public class ActivityRedirection {
    private Long id;
    private User sourceUser;
    private Set<User> targetUsers;
    private Set<UserGroup> targetGroups;
    private String processDefId;
    private String activityDefId;

    public static ActivityRedirection generateSnapshot(ActivityRedirection redirection) {
        ActivityRedirection snapshot = new ActivityRedirection();
        snapshot.setSourceUser(redirection.getSourceUser());
        snapshot.setTargetUsers(ActivityRedirection.usersSnapshots(redirection.getTargetUsers()));
        snapshot.setTargetGroups(ActivityRedirection.groupsSnapshots(redirection.getTargetGroups()));
        snapshot.setProcessDefId(redirection.getProcessDefId());
        snapshot.setActivityDefId(redirection.getActivityDefId());
        return snapshot;
    }

    private static Set<User> usersSnapshots(Set<User> users) {
        if (users == null) {
            return null;
        }
        HashSet userSnapshots = Sets.newHashSet();
        userSnapshots.addAll(users);
        return userSnapshots;
    }

    private static Set<UserGroup> groupsSnapshots(Set<UserGroup> groups) {
        if (groups == null) {
            return null;
        }
        HashSet groupsSnapshots = Sets.newHashSet();
        groupsSnapshots.addAll(groups);
        return groupsSnapshots;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="sourceuser")
    public User getSourceUser() {
        return this.sourceUser;
    }

    public void setSourceUser(User sourceUser) {
        this.sourceUser = sourceUser;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public String getActivityDefId() {
        return this.activityDefId;
    }

    public void setActivityDefId(String activityDefId) {
        this.activityDefId = activityDefId;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="pm_activityredirection_users", joinColumns={@JoinColumn(name="redirection")}, inverseJoinColumns={@JoinColumn(name="targetuser")})
    public Set<User> getTargetUsers() {
        return this.targetUsers;
    }

    public void setTargetUsers(Set<User> targetUsers) {
        this.targetUsers = targetUsers;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_activityredirection_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="pm_activityredirection_groups", joinColumns={@JoinColumn(name="redirection")}, inverseJoinColumns={@JoinColumn(name="targetgroup")})
    public Set<UserGroup> getTargetGroups() {
        return this.targetGroups;
    }

    public void setTargetGroups(Set<UserGroup> targetGroups) {
        this.targetGroups = targetGroups;
    }
}

