/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.suncode.pwfl.util.exception.ServiceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFile
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TempFile.class);
    private final File file;

    public TempFile() {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        log.info("tempDirPath: {}", (Object)tempDirPath);
        File tempDir = new File(tempDirPath);
        if (!tempDir.exists()) {
            throw new ServiceException("Katalog tymczasowy nie istnieje");
        }
        try {
            this.file = File.createTempFile("tmp", "tmp", tempDir);
        }
        catch (IOException e) {
            throw new ServiceException("B\u0142\u0105d podczas tworzenia pliku tymczasowego", e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        FileInputStream fis;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ServiceException("Nie mo\u017cna utworzy\u0107 strumienia z pliku: " + this.file.getAbsolutePath(), e);
        }
        return fis;
    }

    public void delete() {
        this.file.delete();
    }

    @Override
    public void close() throws Exception {
        this.delete();
    }
}

