/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.security.extraverifiers;

import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.security.extraverifiers.AuthenticationParameters;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierDataSourceValueProviderInputValueType;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierValueProvider;
import com.suncode.pwfl.util.SpringContext;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExtraAuthVerifierDataSourceValueProvider
implements ExtraAuthVerifierValueProvider {
    private String dataSourceId;
    private ExtraAuthVerifierDataSourceValueProviderInputValueType inputValue;

    @Override
    public List<String> getValuesToCompare(AuthenticationParameters authenticationParameters) {
        String inputValue;
        DataSourceInstance dataSource = SpringContext.getBean(DataSourceService.class).getDataSource(this.dataSourceId);
        CountedResult<Map<String, Object>> result = dataSource.execute(Collections.singletonMap("value", inputValue = this.getInputValue(authenticationParameters)), null);
        List<Map<String, Object>> data = result.getData();
        if (data.size() == 0) {
            return null;
        }
        return data.stream().map(resultData -> resultData.get("value").toString()).collect(Collectors.toList());
    }

    private String getInputValue(AuthenticationParameters authenticationParameters) {
        switch (this.inputValue) {
            case USERNAME: {
                return authenticationParameters.getUserName();
            }
            case USERNAME_FROM_EXTERNAL_AUTHENTICATOR: {
                return authenticationParameters.getUserNameFromExternalAuthenticator();
            }
        }
        throw new UnsupportedOperationException();
    }

    @ConstructorProperties(value={"dataSourceId", "inputValue"})
    public ExtraAuthVerifierDataSourceValueProvider(String dataSourceId, ExtraAuthVerifierDataSourceValueProviderInputValueType inputValue) {
        this.dataSourceId = dataSourceId;
        this.inputValue = inputValue;
    }
}

