/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.suncode.pwfl.core.type.BasicTypes;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.TypedValue;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public final class Record {
    private final Map<String, Object> fields = new LinkedHashMap<String, Object>();

    public Record() {
        this(Collections.emptyMap());
    }

    public Record(@NonNull Map<String, ?> fields) {
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        fields.forEach(this::put);
    }

    public Record put(@NonNull String field, Object value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value != null) {
            Type<Object> type = Types.typeOf(value);
            Preconditions.checkArgument((boolean)BasicTypes.isBasic(type), (String)"Only BasicTypes values are allowed in record but got %s", type);
        }
        this.fields.put(field, value);
        return this;
    }

    public Map<String, Object> getFields() {
        return new HashMap<String, Object>(this.fields);
    }

    public void set(@NonNull String field, Object value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)this.hasField(field), (String)"No such field %s", (Object)field);
        this.put(field, value);
    }

    public Set<String> getFieldNames() {
        return ImmutableSet.copyOf(this.fields.keySet());
    }

    public boolean hasField(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.fields.containsKey(field);
    }

    public <T> T get(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)this.fields.containsKey(field), (String)"No field in record: %s", (Object)field);
        return (T)this.fields.get(field);
    }

    public static Record empty() {
        return new Record(Collections.emptyMap());
    }

    @SafeVarargs
    public static Record of(Map.Entry<String, Object> ... fields) {
        return new Record(Arrays.stream(fields).collect(Maps.toNullableMap()));
    }

    public static Record of(String field1, Object value1) {
        return Record.of(Maps.entry(field1, value1));
    }

    public static Record of(String field1, Object value1, String field2, Object value2) {
        return Record.of(Maps.entry(field1, value1), Maps.entry(field2, value2));
    }

    public static Record of(String field1, Object value1, String field2, Object value2, String field3, Object value3) {
        return Record.of(Maps.entry(field1, value1), Maps.entry(field2, value2), Maps.entry(field3, value3));
    }

    public static Record of(String field1, Object value1, String field2, Object value2, String field3, Object value3, String field4, Object value4) {
        return Record.of(Maps.entry(field1, value1), Maps.entry(field2, value2), Maps.entry(field3, value3), Maps.entry(field4, value4));
    }

    public static Record of(String field1, Object value1, String field2, Object value2, String field3, Object value3, String field4, Object value4, String field5, Object value5) {
        return Record.of(Maps.entry(field1, value1), Maps.entry(field2, value2), Maps.entry(field3, value3), Maps.entry(field4, value4), Maps.entry(field5, value5));
    }

    public static Record of(String field1, Object value1, String field2, Object value2, String field3, Object value3, String field4, Object value4, String field5, Object value5, String field6, Object value6) {
        return Record.of(Maps.entry(field1, value1), Maps.entry(field2, value2), Maps.entry(field3, value3), Maps.entry(field4, value4), Maps.entry(field5, value5), Maps.entry(field6, value6));
    }

    public static RecordBuilder builder() {
        return new RecordBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)o;
        Map<String, Object> this$fields = this.getFields();
        Map<String, Object> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "Record(fields=" + this.getFields() + ")";
    }

    public static class RecordBuilder {
        private ArrayList<String> fields$key;
        private ArrayList<Object> fields$value;

        public RecordBuilder put(@NonNull String fieldName, Object value) {
            if (fieldName == null) {
                throw new NullPointerException("fieldName is marked non-null but is null");
            }
            return this.field(fieldName, new TypedValue<Object>(value, Types.typeOf(value)));
        }

        RecordBuilder() {
        }

        public RecordBuilder field(String fieldKey, Object fieldValue) {
            if (this.fields$key == null) {
                this.fields$key = new ArrayList();
                this.fields$value = new ArrayList();
            }
            this.fields$key.add(fieldKey);
            this.fields$value.add(fieldValue);
            return this;
        }

        public RecordBuilder fields(Map<? extends String, ?> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields$key == null) {
                this.fields$key = new ArrayList();
                this.fields$value = new ArrayList();
            }
            for (Map.Entry<String, ?> $lombokEntry : fields.entrySet()) {
                this.fields$key.add($lombokEntry.getKey());
                this.fields$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RecordBuilder clearFields() {
            if (this.fields$key != null) {
                this.fields$key.clear();
                this.fields$value.clear();
            }
            return this;
        }

        public Record build() {
            Map<Object, Object> fields;
            switch (this.fields$key == null ? 0 : this.fields$key.size()) {
                case 0: {
                    fields = Collections.emptyMap();
                    break;
                }
                case 1: {
                    fields = Collections.singletonMap(this.fields$key.get(0), this.fields$value.get(0));
                    break;
                }
                default: {
                    fields = new LinkedHashMap(this.fields$key.size() < 0x40000000 ? 1 + this.fields$key.size() + (this.fields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.fields$key.size(); ++$i) {
                        fields.put(this.fields$key.get($i), this.fields$value.get($i));
                    }
                    fields = Collections.unmodifiableMap(fields);
                }
            }
            return new Record(fields);
        }

        public String toString() {
            return "Record.RecordBuilder(fields$key=" + this.fields$key + ", fields$value=" + this.fields$value + ")";
        }
    }
}

