/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.archive;

import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.workflow.activity.ActivityDocument;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="pm_file_versions")
@SequenceGenerator(name="file_versions_file_id_seq", sequenceName="file_versions_file_id_seq")
public class WfFileVersion {
    private WfFile file;
    private WfFile parentFile;
    private WfFile newestFile;
    private Date checkOutDate;
    private Date checkInDate;
    private Date replaceDate;
    private String checkOutUserName;
    private String state;
    private String comment;
    private int version;
    private Long id;
    private Set<ActivityDocument> activityDocuments;

    public WfFileVersion(WfFile file) {
        this.checkInDate = new Date();
        this.file = file;
        this.newestFile = file;
        this.state = State.STATE_READY.toString();
        this.version = 1;
    }

    public WfFileVersion(WfFile file, String uploader) {
        this.checkInDate = new Date();
        this.file = file;
        this.newestFile = file;
        this.state = State.STATE_READY.toString();
        this.version = 1;
    }

    @Fetch(value=FetchMode.JOIN)
    @OneToOne
    @JoinColumn(name="fileid")
    public WfFile getFile() {
        return this.file;
    }

    public void setFile(WfFile file) {
        this.file = file;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @Column(name="file_comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="replace_date")
    public Date getReplaceDate() {
        return this.replaceDate;
    }

    public void setReplaceDate(Date replaceDate) {
        this.replaceDate = replaceDate;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_fileid")
    public WfFile getParentFile() {
        return this.parentFile;
    }

    public void setParentFile(WfFile parentFile) {
        this.parentFile = parentFile;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="newest_fileid")
    public WfFile getNewestFile() {
        return this.newestFile;
    }

    public void setNewestFile(WfFile newestFile) {
        this.newestFile = newestFile;
    }

    @Column(name="checkout_date")
    public Date getCheckOutDate() {
        return this.checkOutDate;
    }

    public void setCheckOutDate(Date checkOutDate) {
        this.checkOutDate = checkOutDate;
    }

    @Column(name="checkin_date")
    public Date getCheckInDate() {
        return this.checkInDate;
    }

    public void setCheckInDate(Date checkInDate) {
        this.checkInDate = checkInDate;
    }

    @Column(name="checkout_user")
    public String getCheckOutUserName() {
        return this.checkOutUserName;
    }

    public void setCheckOutUserName(String checkOutUserName) {
        this.checkOutUserName = checkOutUserName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="file_versions_file_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @OneToMany(mappedBy="version", cascade={CascadeType.ALL})
    public Set<ActivityDocument> getActivityDocuments() {
        return this.activityDocuments;
    }

    public void setActivityDocuments(Set<ActivityDocument> activityDocuments) {
        this.activityDocuments = activityDocuments;
    }

    public static WfFileVersionBuilder builder() {
        return new WfFileVersionBuilder();
    }

    public WfFileVersion() {
    }

    @ConstructorProperties(value={"file", "parentFile", "newestFile", "checkOutDate", "checkInDate", "replaceDate", "checkOutUserName", "state", "comment", "version", "id", "activityDocuments"})
    public WfFileVersion(WfFile file, WfFile parentFile, WfFile newestFile, Date checkOutDate, Date checkInDate, Date replaceDate, String checkOutUserName, String state, String comment, int version, Long id, Set<ActivityDocument> activityDocuments) {
        this.file = file;
        this.parentFile = parentFile;
        this.newestFile = newestFile;
        this.checkOutDate = checkOutDate;
        this.checkInDate = checkInDate;
        this.replaceDate = replaceDate;
        this.checkOutUserName = checkOutUserName;
        this.state = state;
        this.comment = comment;
        this.version = version;
        this.id = id;
        this.activityDocuments = activityDocuments;
    }

    public static enum State {
        STATE_READY,
        STATE_EDIT;

    }

    public static class WfFileVersionBuilder {
        private WfFile file;
        private WfFile parentFile;
        private WfFile newestFile;
        private Date checkOutDate;
        private Date checkInDate;
        private Date replaceDate;
        private String checkOutUserName;
        private String state;
        private String comment;
        private int version;
        private Long id;
        private Set<ActivityDocument> activityDocuments;

        WfFileVersionBuilder() {
        }

        public WfFileVersionBuilder file(WfFile file) {
            this.file = file;
            return this;
        }

        public WfFileVersionBuilder parentFile(WfFile parentFile) {
            this.parentFile = parentFile;
            return this;
        }

        public WfFileVersionBuilder newestFile(WfFile newestFile) {
            this.newestFile = newestFile;
            return this;
        }

        public WfFileVersionBuilder checkOutDate(Date checkOutDate) {
            this.checkOutDate = checkOutDate;
            return this;
        }

        public WfFileVersionBuilder checkInDate(Date checkInDate) {
            this.checkInDate = checkInDate;
            return this;
        }

        public WfFileVersionBuilder replaceDate(Date replaceDate) {
            this.replaceDate = replaceDate;
            return this;
        }

        public WfFileVersionBuilder checkOutUserName(String checkOutUserName) {
            this.checkOutUserName = checkOutUserName;
            return this;
        }

        public WfFileVersionBuilder state(String state) {
            this.state = state;
            return this;
        }

        public WfFileVersionBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public WfFileVersionBuilder version(int version) {
            this.version = version;
            return this;
        }

        public WfFileVersionBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WfFileVersionBuilder activityDocuments(Set<ActivityDocument> activityDocuments) {
            this.activityDocuments = activityDocuments;
            return this;
        }

        public WfFileVersion build() {
            return new WfFileVersion(this.file, this.parentFile, this.newestFile, this.checkOutDate, this.checkInDate, this.replaceDate, this.checkOutUserName, this.state, this.comment, this.version, this.id, this.activityDocuments);
        }

        public String toString() {
            return "WfFileVersion.WfFileVersionBuilder(file=" + this.file + ", parentFile=" + this.parentFile + ", newestFile=" + this.newestFile + ", checkOutDate=" + this.checkOutDate + ", checkInDate=" + this.checkInDate + ", replaceDate=" + this.replaceDate + ", checkOutUserName=" + this.checkOutUserName + ", state=" + this.state + ", comment=" + this.comment + ", version=" + this.version + ", id=" + this.id + ", activityDocuments=" + this.activityDocuments + ")";
        }
    }
}

