/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.plusmpm.security.DesEncrypter;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;

@Entity
@Table(name="pm_domainservers")
@SequenceGenerator(name="pm_domainservers_id_seq", sequenceName="pm_domainservers_id_seq")
public class Domain {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_domainservers_id_seq")
    private Long id;
    private String domainName;
    private String domainServerAdres;
    private Long domainServerPort;
    private String domainUser;
    private String domainUserPassword;
    private String domainBaseSearch;
    private String usernameTemplate;
    private String usernameMapping;
    private String firstnameMapping;
    private String lastnameMapping;
    private String emailMapping;
    private String memberMapping;
    private String memberOfMapping;
    private String userAttributeMapping;
    private String groupAttributeMapping;
    private String numberMapping;
    private Boolean ldapOverSsl;
    private Boolean startTLS;

    public Domain() {
    }

    public Domain(String domainName, String domainServerAdres, Long domainServerPort, String domainUser, String domainUserPassword, String domainBaseSearch) {
        this(domainName, domainServerAdres, domainServerPort, domainUser, domainUserPassword, domainBaseSearch, null);
    }

    public Domain(String domainName, String domainServerAdres, Long domainServerPort, String domainUser, String domainUserPassword, String domainBaseSearch, String usernameTemplate) {
        DesEncrypter d = new DesEncrypter();
        this.domainName = domainName;
        this.domainServerAdres = domainServerAdres;
        this.domainServerPort = domainServerPort;
        this.domainUser = domainUser;
        this.domainUserPassword = d.encrypt(domainUserPassword);
        this.domainBaseSearch = domainBaseSearch;
        this.usernameTemplate = usernameTemplate;
    }

    public Domain(String id, String domainName, String domainServerAdres, Long domainServerPort, String domainUser, String domainUserPassword, String domainBaseSearch) {
        this(domainName, domainServerAdres, domainServerPort, domainUser, domainUserPassword, domainBaseSearch);
        this.id = Long.parseLong(id);
    }

    @Transient
    public String getDecryptedPassword() {
        if (this.domainUserPassword == null) {
            return null;
        }
        DesEncrypter d = new DesEncrypter();
        return d.decrypt(this.domainUserPassword);
    }

    public Boolean isLdapOverSsl() {
        return this.ldapOverSsl;
    }

    public Boolean isStartTLS() {
        return this.startTLS;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public void setDomainServerAdres(String domainServerAdres) {
        this.domainServerAdres = domainServerAdres;
    }

    public void setDomainServerPort(Long domainServerPort) {
        this.domainServerPort = domainServerPort;
    }

    public void setDomainUser(String domainUser) {
        this.domainUser = domainUser;
    }

    public void setDomainUserPassword(String domainUserPassword) {
        this.domainUserPassword = domainUserPassword;
    }

    public void setDomainBaseSearch(String domainBaseSearch) {
        this.domainBaseSearch = domainBaseSearch;
    }

    public void setUsernameTemplate(String usernameTemplate) {
        this.usernameTemplate = usernameTemplate;
    }

    public void setUsernameMapping(String usernameMapping) {
        this.usernameMapping = usernameMapping;
    }

    public void setFirstnameMapping(String firstnameMapping) {
        this.firstnameMapping = firstnameMapping;
    }

    public void setLastnameMapping(String lastnameMapping) {
        this.lastnameMapping = lastnameMapping;
    }

    public void setEmailMapping(String emailMapping) {
        this.emailMapping = emailMapping;
    }

    public void setMemberMapping(String memberMapping) {
        this.memberMapping = memberMapping;
    }

    public void setMemberOfMapping(String memberOfMapping) {
        this.memberOfMapping = memberOfMapping;
    }

    public void setUserAttributeMapping(String userAttributeMapping) {
        this.userAttributeMapping = userAttributeMapping;
    }

    public void setGroupAttributeMapping(String groupAttributeMapping) {
        this.groupAttributeMapping = groupAttributeMapping;
    }

    public void setNumberMapping(String numberMapping) {
        this.numberMapping = numberMapping;
    }

    public void setLdapOverSsl(Boolean ldapOverSsl) {
        this.ldapOverSsl = ldapOverSsl;
    }

    public void setStartTLS(Boolean startTLS) {
        this.startTLS = startTLS;
    }

    public Long getId() {
        return this.id;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDomainServerAdres() {
        return this.domainServerAdres;
    }

    public Long getDomainServerPort() {
        return this.domainServerPort;
    }

    public String getDomainUser() {
        return this.domainUser;
    }

    public String getDomainUserPassword() {
        return this.domainUserPassword;
    }

    public String getDomainBaseSearch() {
        return this.domainBaseSearch;
    }

    public String getUsernameTemplate() {
        return this.usernameTemplate;
    }

    public String getUsernameMapping() {
        return this.usernameMapping;
    }

    public String getFirstnameMapping() {
        return this.firstnameMapping;
    }

    public String getLastnameMapping() {
        return this.lastnameMapping;
    }

    public String getEmailMapping() {
        return this.emailMapping;
    }

    public String getMemberMapping() {
        return this.memberMapping;
    }

    public String getMemberOfMapping() {
        return this.memberOfMapping;
    }

    public String getUserAttributeMapping() {
        return this.userAttributeMapping;
    }

    public String getGroupAttributeMapping() {
        return this.groupAttributeMapping;
    }

    public String getNumberMapping() {
        return this.numberMapping;
    }

    public Boolean getLdapOverSsl() {
        return this.ldapOverSsl;
    }

    public Boolean getStartTLS() {
        return this.startTLS;
    }
}

