/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.action;

import com.suncode.pwfl.workflow.form.action.ActionDestination;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.util.Assert;

public class ActionTarget {
    private String id;
    private ActionDestination.Type type;

    private ActionTarget(ActionDestination.Type type) {
        this(null, type);
    }

    public ActionTarget(String id, ActionDestination.Type type) {
        Assert.notNull((Object)((Object)type), (String)"[Assertion failed] - this argument is required; it must not be null");
        if (type != ActionDestination.Type.FORM) {
            Assert.hasText((String)id, (String)"Id must be specified for type other than FORM");
        }
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public ActionDestination.Type getType() {
        return this.type;
    }

    public static ActionTarget form() {
        return new ActionTarget(ActionDestination.Type.FORM);
    }

    public static ActionTarget variable() {
        return new ActionTarget(ActionDestination.Type.VARIABLE);
    }

    public static ActionTarget variable(String bindParameterId) {
        return new ActionTarget(bindParameterId, ActionDestination.Type.VARIABLE);
    }

    public static ActionTarget variableSet() {
        return new ActionTarget(ActionDestination.Type.VARIABLESET);
    }

    public static ActionTarget variableSet(String bindParameterId) {
        return new ActionTarget(bindParameterId, ActionDestination.Type.VARIABLESET);
    }

    public static ActionTarget button() {
        return new ActionTarget(ActionDestination.Type.BUTTON);
    }

    public static ActionTarget button(String bindParameterId) {
        return new ActionTarget(bindParameterId, ActionDestination.Type.BUTTON);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.type).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ActionTarget) {
            ActionTarget other = (ActionTarget)obj;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.type, (Object)other.type).isEquals();
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.type + (String)(this.id != null ? "(" + this.id + ")" : "");
    }
}

