/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.datachooser;

import com.google.common.collect.ImmutableList;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.exception.UnknownParameterException;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.component.InvocableComponent;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserContext;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinition;
import com.suncode.pwfl.workflow.form.datachooser.Mapping;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class DataChooser
extends InvocableComponent {
    public static final String DATA_METHOD_NAME = "data";
    private Map<String, Mapping> mappings;
    private boolean customMappingsEnabled;

    public DataChooser(DataChooserDefinition definition, Method method, Object instance) {
        super(definition, method, instance);
        this.mappings = definition.getMappings();
        this.customMappingsEnabled = definition.areCustomMappingsEnabled();
    }

    public List<Mapping> getMappings() {
        return ImmutableList.copyOf(this.mappings.values());
    }

    public Mapping getMapping(String id) throws UnknownParameterException {
        Mapping mapping = this.mappings.get(id);
        if (mapping != null) {
            return mapping;
        }
        throw new UnknownParameterException(this, id);
    }

    public boolean areCustomMappingsEnabled() {
        return this.customMappingsEnabled;
    }

    @Override
    public void invoke(Parameters parameters, ActivityContextMap activityContextMap, ContextVariables contextVariables) {
        DataChooserContext context = DataChooserContext.current();
        super.invoke(parameters, activityContextMap, contextVariables, context, context.getQueryData(), context.getResult());
    }
}

