/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component.support;

import com.google.common.collect.Maps;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.component.support.InvocableMethod;
import com.suncode.pwfl.component.support.ParameterBinder;
import com.suncode.pwfl.datasource.DataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceService;
import com.suncode.pwfl.util.SpringContext;
import java.util.LinkedHashMap;
import org.springframework.util.Assert;

public class ParametersBinder
implements ParameterBinder {
    private final Parameters parameters;
    private boolean requireParamAnnotation = true;

    public ParametersBinder(Parameters parameters) {
        this(parameters, true);
    }

    public ParametersBinder(Parameters parameters, boolean requireParamAnnotation) {
        Assert.notNull((Object)parameters);
        this.parameters = parameters;
        this.requireParamAnnotation = requireParamAnnotation;
    }

    @Override
    public boolean shouldBind(int index, Class<?> type, InvocableMethod method) {
        if (method.hasParameterAnnotation(index, PairedParam.class)) {
            return this.shouldBindPairedParameter(index, type, method);
        }
        String paramName = method.getParameterName(index);
        boolean paramPresent = this.parameters.exists(paramName);
        if (method.hasParameterAnnotation(index, Param.class)) {
            if (!paramPresent) {
                throw new IllegalArgumentException("Parameter [" + paramName + "] does not exists!");
            }
            return true;
        }
        return !this.requireParamAnnotation && paramPresent;
    }

    private boolean shouldBindPairedParameter(int index, Class<?> type, InvocableMethod method) {
        if (!type.isAssignableFrom(LinkedHashMap.class)) {
            throw new IllegalArgumentException("Paired parameter [" + method.getParameterName(index) + "] must be a LinkedHashMap type.");
        }
        PairedParam annotation = (PairedParam)method.getParameterAnnotation(index, PairedParam.class);
        boolean keyParamPresent = this.parameters.exists(annotation.key());
        boolean valueParamPresent = this.parameters.exists(annotation.value());
        if (!keyParamPresent) {
            throw new IllegalArgumentException("Parameter [" + annotation.key() + "] does not exists!");
        }
        if (!valueParamPresent) {
            throw new IllegalArgumentException("Parameter [" + annotation.value() + "] does not exists!");
        }
        return true;
    }

    @Override
    public Object bind(int index, Class<?> type, InvocableMethod method) {
        if (method.hasParameterAnnotation(index, PairedParam.class)) {
            return this.bindPairedParameter(index, type, method);
        }
        if (type.isAssignableFrom(DataSourceInstance.class)) {
            DataSourceService dss = SpringContext.getBean(DataSourceService.class);
            return dss.getDataSource(this.parameters.get(method.getParameterName(index), String.class));
        }
        return this.parameters.get(method.getParameterName(index), type);
    }

    private Object bindPairedParameter(int index, Class<?> type, InvocableMethod method) {
        PairedParam annotation = (PairedParam)method.getParameterAnnotation(index, PairedParam.class);
        Object[] keyParameter = (Object[])this.parameters.get(annotation.key());
        Object[] valueParameter = (Object[])this.parameters.get(annotation.value());
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (keyParameter == null || keyParameter.length == 0) {
            return map;
        }
        for (int i = 0; i < keyParameter.length; ++i) {
            Object value = valueParameter == null || valueParameter.length <= i ? null : valueParameter[i];
            map.put(keyParameter[i], value);
        }
        return map;
    }
}

