/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.validator;

import com.suncode.pwfl.core.context.ContextHolder;
import com.suncode.pwfl.core.context.ContextNotActiveException;
import com.suncode.pwfl.core.context.InContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.form.validator.error.DefinedConfirmation;
import com.suncode.pwfl.workflow.form.validator.error.DefinedError;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import org.springframework.util.Assert;

public class ValidationContext
extends WorkflowContext {
    public static final String NAME = "validationcontext";
    private final String actionName;
    private final ValidationErrors errors;
    private DefinedConfirmation confirmation;
    private DefinedError error;
    private static final ContextHolder<ValidationContext> holder = new ContextHolder("validationcontext", true);

    protected ValidationContext(String processId, String activityId, String actionName, ValidationErrors errors) {
        super(processId, activityId);
        Assert.notNull((Object)errors);
        if (actionName != null) {
            Assert.hasText((String)actionName);
        }
        this.errors = errors;
        this.actionName = actionName;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String getActionName() {
        return this.actionName;
    }

    public ValidationErrors getValidationErrors() {
        return this.errors;
    }

    public DefinedConfirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(DefinedConfirmation confirmation) {
        this.confirmation = confirmation;
    }

    public DefinedError getError() {
        return this.error;
    }

    public void setError(DefinedError error) {
        this.error = error;
    }

    public boolean isDefaultAction() {
        return this.actionName == null;
    }

    public static boolean isActive() {
        return holder.isActive();
    }

    public static ValidationContext current() throws ContextNotActiveException {
        return holder.current();
    }

    public static ValidationContext activate(String processId, String activityId, String actionName, ValidationErrors errors) {
        ValidationContext.activateFunctionContext(processId, activityId);
        ValidationContext context = new ValidationContext(processId, activityId, actionName, errors);
        holder.activate(context);
        return context;
    }

    public static void activate(String processId, String activityId, String actionName, ValidationErrors errors, InContext<ValidationContext> action) {
        ValidationContext.deactivateFunctionContext();
        ValidationContext context = new ValidationContext(processId, activityId, actionName, errors);
        holder.activate(context, action);
    }

    public static ValidationContext deactivate() {
        ValidationContext.deactivateFunctionContext();
        return holder.remove();
    }

    @Override
    public void disableLogging() {
        ValidationContext.current().enableLog = false;
    }

    @Override
    public void enableLogging() {
        ValidationContext.current().enableLog = true;
    }
}

