/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.view;

import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.GlobalParams;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class ViewResultAction {
    private ViewResultActionType type;
    private String nameKey;
    private String relativePath;
    private String confirmationKey;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();

    protected ViewResultAction(ViewResultActionType type, String nameKey, String relativePath) {
        this(type, nameKey, relativePath, null);
    }

    protected ViewResultAction(ViewResultActionType type, String nameKey, String relativePath, String confirmationKey) {
        this.type = type;
        this.nameKey = nameKey;
        this.relativePath = relativePath;
        this.confirmationKey = confirmationKey;
    }

    public String getName() {
        return MessageHelper.getMessage((String)this.nameKey);
    }

    public Optional<String> getConfirmation() {
        if (!this.hasConfirmation()) {
            return Optional.empty();
        }
        return Optional.of(MessageHelper.getMessage((String)this.confirmationKey) + "?");
    }

    private boolean hasConfirmation() {
        return StringUtils.isNotBlank((CharSequence)this.confirmationKey);
    }

    public String getLink() {
        String basePath = GlobalParams.getServletContext().getContextPath() + "/" + this.relativePath;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)basePath);
        this.parameters.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        return builder.build().toUriString();
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public ViewResultActionType getType() {
        return this.type;
    }

    public static enum ViewResultActionType {
        OpenActivity,
        ShowActivityDetails,
        ResumeActivity,
        SuspendActivity,
        AbortActivity,
        ShowProcessHistory,
        AbortProcess,
        DeleteProcess;

    }
}

