/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.activity;

public enum ActivityState {
    RUNNING("open.running", 1000001L),
    NOT_STARTED("open.not_running.not_started", 1000003L),
    SUSPENDED("open.not_running.suspended", 1000005L),
    COMPLETED("closed.completed", 1000007L),
    TERMINATED("closed.terminated", 1000009L),
    ABORTED("closed.aborted", 1000011L),
    PROCESSING("", 0L);

    private String state;
    private long number;

    public String getStateText() {
        return this.state;
    }

    public long getStateNumber() {
        return this.number;
    }

    private ActivityState(String state, long number) {
        this.state = state;
        this.number = number;
    }

    public static ActivityState getState(String state) {
        if (state == null) {
            return null;
        }
        if (state.equals("open.running")) {
            return RUNNING;
        }
        if (state.equals("open.not_running.not_started")) {
            return NOT_STARTED;
        }
        if (state.equals("open.not_running.suspended")) {
            return SUSPENDED;
        }
        if (state.equals("closed.completed")) {
            return COMPLETED;
        }
        if (state.equals("closed.terminated")) {
            return TERMINATED;
        }
        if (state.equals("closed.aborted")) {
            return ABORTED;
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany stan: " + state);
    }

    public static boolean isOpen(ActivityState state) {
        return state.equals((Object)RUNNING) || state.equals((Object)NOT_STARTED) || state.equals((Object)SUSPENDED);
    }

    public static String getSharkState(ActivityState state) {
        if (state == NOT_STARTED) {
            return "open.not_running.not_started";
        }
        if (state == ABORTED) {
            return "closed.aborted";
        }
        if (state == COMPLETED) {
            return "closed.completed";
        }
        if (state == RUNNING) {
            return "open.running";
        }
        if (state == SUSPENDED) {
            return "open.not_running.suspended";
        }
        if (state == TERMINATED) {
            return "closed.terminated";
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany stan: " + (Object)((Object)state));
    }
}

