/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

public class VersionVerifier {
    public static boolean isVersionSufficient(String requiredVersion, String version) {
        String[] system;
        boolean isSystemSnapshot = version.contains("SNAPSHOT");
        if (isSystemSnapshot) {
            version = version.substring(0, version.length() - 9);
        }
        version = version.replace("SR", "").replace("RC", "-");
        String[] required = (requiredVersion = requiredVersion.replace("SR", "").replace("RC", "-")).split("\\.");
        int length = required.length > (system = version.split("\\.")).length ? required.length : system.length;
        for (int i = 0; i < length; ++i) {
            if (system.length < i + 1) {
                return isSystemSnapshot || VersionVerifier.parseNumber(required[i]) < 0L;
            }
            if (required.length < i + 1) {
                return VersionVerifier.parseNumber(system[i]) >= 0L;
            }
            long requiredNumber = VersionVerifier.parseNumber(required[i]);
            long systemNumber = VersionVerifier.parseNumber(system[i]);
            if (systemNumber < 0L && requiredNumber < 0L) {
                systemNumber *= -1L;
                requiredNumber *= -1L;
            }
            if (systemNumber > requiredNumber) {
                return true;
            }
            if (systemNumber >= requiredNumber) continue;
            return false;
        }
        return true;
    }

    private static long parseNumber(String number) {
        try {
            return Long.valueOf(number);
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

