/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.search.sql;

import com.suncode.pwfl.search.FilterOperator;
import com.suncode.pwfl.search.FilterOperatorNotSupported;
import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.sql.SQLFilter;
import java.util.List;
import org.hibernate.SQLQuery;

public class SQLQueryBuilder {
    public static String buildOperator(FilterOperator operator) {
        StringBuilder sb = new StringBuilder();
        SQLQueryBuilder.buildOperator(sb, operator);
        return sb.toString();
    }

    public static void buildOperator(StringBuilder query, FilterOperator operator) {
        if (operator.equals((Object)FilterOperator.EQ)) {
            query.append(" = ");
        } else if (operator.equals((Object)FilterOperator.NOTEQ)) {
            query.append(" != ");
        } else if (operator.equals((Object)FilterOperator.LIKE) || operator.equals((Object)FilterOperator.ILIKE)) {
            query.append(" like ");
        } else if (operator.equals((Object)FilterOperator.NOTLIKE) || operator.equals((Object)FilterOperator.NOTILIKE)) {
            query.append(" not like ");
        } else if (operator.equals((Object)FilterOperator.IN)) {
            query.append(" in ");
        } else if (operator.equals((Object)FilterOperator.NOTIN)) {
            query.append(" not in ");
        } else if (operator.equals((Object)FilterOperator.ISNULL)) {
            query.append(" is null ");
        } else if (operator.equals((Object)FilterOperator.NOTNULL)) {
            query.append(" is not null ");
        } else if (operator.equals((Object)FilterOperator.LT)) {
            query.append(" < ");
        } else if (operator.equals((Object)FilterOperator.GT)) {
            query.append(" > ");
        } else if (operator.equals((Object)FilterOperator.LE)) {
            query.append(" <= ");
        } else if (operator.equals((Object)FilterOperator.GE)) {
            query.append(" >= ");
        } else if (operator.equals((Object)FilterOperator.BETWEEN)) {
            query.append(" between ");
        } else {
            throw new FilterOperatorNotSupported("Podany operator nie jest wspierany: " + (Object)((Object)operator));
        }
    }

    public static void buildWhere(StringBuilder query, List<? extends SQLFilter> sqlFilters) {
        Integer i = 0;
        String and = SQLQueryBuilder.buildOperator(LogicOperator.AND);
        for (SQLFilter sQLFilter : sqlFilters) {
            i = sQLFilter.buildWhere(query, i);
            query.append(and);
        }
        if (!sqlFilters.isEmpty()) {
            query.setLength(query.length() - and.length());
        }
    }

    public static String buildWhere(List<SQLFilter> sqlFilters) {
        StringBuilder query = new StringBuilder();
        SQLQueryBuilder.buildWhere(query, sqlFilters);
        return query.toString();
    }

    public static void buildOrder(StringBuilder query, List<Sorter> sorters) {
        for (Sorter sorter : sorters) {
            query.append(sorter.getProperty());
            query.append(" ");
            query.append((Object)sorter.getDirection());
            query.append(",");
        }
        if (!sorters.isEmpty()) {
            query.setLength(query.length() - 1);
        }
    }

    public static String buildOrder(List<Sorter> sorters) {
        StringBuilder sb = new StringBuilder();
        SQLQueryBuilder.buildOrder(sb, sorters);
        return sb.toString();
    }

    public static void setFilterValues(SQLQuery sql, List<? extends SQLFilter> indexFilters) {
        for (SQLFilter sQLFilter : indexFilters) {
            sQLFilter.setFilterValue(sql);
        }
    }

    public static String buildOperator(LogicOperator logicOperator) {
        if (LogicOperator.AND == logicOperator) {
            return " and ";
        }
        return " or ";
    }
}

