/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.search.sql;

import com.suncode.pwfl.search.LogicOperator;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLQueryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;

public class GroupFilter<T extends SQLFilter>
implements SQLFilter {
    private LogicOperator logicOperator = LogicOperator.AND;
    private List<T> filters;

    public GroupFilter() {
    }

    public GroupFilter(List<T> filters) {
        this.filters = filters;
    }

    public GroupFilter(List<T> filters, LogicOperator logicOperator) {
        this.logicOperator = logicOperator;
        this.filters = filters;
    }

    public GroupFilter(LogicOperator logicOperator) {
        this.logicOperator = logicOperator;
    }

    public LogicOperator getLogicOperator() {
        return this.logicOperator;
    }

    public void setLogicOperator(LogicOperator logicOperator) {
        this.logicOperator = logicOperator;
    }

    public List<T> getFilters() {
        return this.filters;
    }

    public void setFilters(List<T> filters) {
        this.filters = filters;
    }

    @Override
    public void setFilterValue(SQLQuery sql) {
        for (SQLFilter filter : this.filters) {
            filter.setFilterValue(sql);
        }
    }

    public void addFilter(T ... filters) {
        if (this.filters == null) {
            this.filters = new ArrayList<T>();
        }
        for (T sqlFilter : filters) {
            this.filters.add(sqlFilter);
        }
    }

    @Override
    public int buildWhere(StringBuilder sb, Integer i) {
        sb.append(" ( ");
        String op = SQLQueryBuilder.buildOperator(this.getLogicOperator());
        for (SQLFilter filter : this.filters) {
            i = filter.buildWhere(sb, i);
            sb.append(op);
        }
        sb.setLength(sb.length() - op.length());
        sb.append(" ) ");
        return i;
    }

    @Override
    public void setFilterValue(Map<String, Object> params) {
        for (SQLFilter filter : this.filters) {
            filter.setFilterValue(params);
        }
    }
}

