/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonSerializable;
import com.suncode.pwfl.util.Predicates;
import com.suncode.pwfl.util.Throwing;
import java.util.Optional;

public abstract class JsonTypeBase<T>
extends TypeBase<T>
implements JsonSerializable<T> {
    private static final ObjectMapper mapperInstance = new ObjectMapper();

    public JsonTypeBase(Class<T> javaType, T defaultValue) {
        super(javaType, defaultValue);
    }

    @Override
    public JsonNode serializeJson(T value) {
        if (this.isValueEmpty(value)) {
            return this.emptyNode();
        }
        return this.serializeNonNullValue(this.read(value));
    }

    @Override
    public T deserializeJson(JsonNode json) {
        if (this.isNodeEmpty(json)) {
            return this.emptyValue();
        }
        return this.deserializeNonEmptyNode(json);
    }

    public abstract String translationKey();

    protected abstract JsonNode serializeNonNullValue(T var1);

    protected abstract T deserializeNonEmptyNode(JsonNode var1);

    protected T emptyValue() {
        return null;
    }

    protected JsonNode emptyNode() {
        return NullNode.instance;
    }

    protected boolean isValueEmpty(T value) {
        return value == null;
    }

    protected boolean isNodeEmpty(JsonNode json) {
        return json == null || json.isNull() || json.isTextual() && json.asText().isEmpty();
    }

    protected T convertFromJsonString(String jsonString) {
        return Optional.ofNullable(jsonString).filter(Predicates.not(String::isEmpty)).map(Throwing.throwing(arg_0 -> ((ObjectMapper)mapperInstance).readTree(arg_0))).map(this::deserializeNonEmptyNode).orElse(null);
    }

    protected String convertToJsonString(T value) {
        return mapperInstance.writeValueAsString((Object)this.serializeJson(value));
    }
}

