/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.suncode.pwfl.core.type.TypeBase;
import com.suncode.pwfl.core.type.support.JsonTypeBase;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateType
extends JsonTypeBase<LocalDate> {
    public static final DateType INSTANCE = new DateType();

    private DateType() {
        super(LocalDate.class, null);
        this.converter(String.class, new TypeBase.Convert<String, LocalDate>(){

            @Override
            public String fromBase(LocalDate value) {
                return value.toString(ISODateTimeFormat.date());
            }

            @Override
            public LocalDate toBase(String value) {
                return DateType.this.convert(value);
            }
        });
    }

    @Override
    public String name() {
        return "date";
    }

    @Override
    public String translationKey() {
        return "Datowy";
    }

    @Override
    protected JsonNode serializeNonNullValue(LocalDate value) {
        return TextNode.valueOf((String)this.readAs(value, String.class));
    }

    @Override
    protected LocalDate deserializeNonEmptyNode(JsonNode json) {
        return json.isNumber() ? new LocalDate(json.asLong()) : LocalDate.parse((String)json.asText(), (DateTimeFormatter)ISODateTimeFormat.localDateParser());
    }

    @Override
    public LocalDate convert(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (this.timeInMillis(value)) {
            return new LocalDate(Long.parseLong(value));
        }
        return LocalDate.parse((String)value, (DateTimeFormatter)ISODateTimeFormat.localDateParser());
    }

    private boolean timeInMillis(String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

