/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.function;

import com.suncode.pwfl.core.function.Contextual;
import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.FunctionOverride;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.TypedValue;
import com.suncode.pwfl.workflow.component.ContextVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.Assert;

public class FunctionCall {
    private final FunctionOverride override;
    private final Object[] args;

    public FunctionCall(Function fn, Type<?> returnType, Object ... args) {
        this(FunctionCall.valid(fn.getOverride(returnType, args), "There is no matching function " + fn + " override for args: " + args + " and return type " + returnType.name()), args);
    }

    public FunctionCall(Function fn, Type<?> returnType, List<Type<?>> parameterTypes, Object ... args) {
        this(FunctionCall.valid(fn.getOverride(returnType, (Type<?>[])parameterTypes.toArray(new Type[parameterTypes.size()])), "There is no matching function " + fn + " override for parameter types: " + parameterTypes + " and return type " + returnType.name()), args);
    }

    public FunctionCall(FunctionOverride override, Object ... args) {
        Assert.notNull((Object)override, (String)"Function override must not be null");
        this.override = override;
        this.args = args;
    }

    private static FunctionOverride valid(FunctionOverride override, String message) {
        if (override == null) {
            throw new IllegalArgumentException(message);
        }
        return override;
    }

    public String getName() {
        return this.getFunction().getName();
    }

    public Function getFunction() {
        return this.override.getFunction();
    }

    public FunctionOverride getOverride() {
        return this.override;
    }

    public Type<?> getReturnType() {
        return this.override.getReturnType();
    }

    public Object[] getArgs() {
        return (Object[])this.args.clone();
    }

    public <T> T call() {
        return this.override.call(this.args);
    }

    public List<ContextVariable<?>> getContextVariables() {
        ArrayList result = new ArrayList();
        this.resolveContextVariables(this.args, result);
        return result;
    }

    private void resolveContextVariables(Object arg, List<ContextVariable<?>> args) {
        block3: {
            Object val;
            block5: {
                block4: {
                    block2: {
                        if (!(arg instanceof Object[])) break block2;
                        for (Object argN : (Object[])arg) {
                            this.resolveContextVariables(argN, args);
                        }
                        break block3;
                    }
                    if (!(arg instanceof Contextual)) break block4;
                    args.add(((Contextual)arg).getContextVariable());
                    break block3;
                }
                if (!(arg instanceof TypedValue)) break block3;
                val = ((TypedValue)arg).get();
                if (!(val instanceof FunctionCall)) break block5;
                args.addAll(((FunctionCall)val).getContextVariables());
                break block3;
            }
            if (!(val instanceof FunctionCall[])) break block3;
            for (FunctionCall fnCall : (FunctionCall[])val) {
                args.addAll(fnCall.getContextVariables());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("#").append(this.override.getName()).append("(");
        if (this.args.length > 0) {
            for (Object arg : this.args) {
                sb.append(this.getValueToPrint(arg)).append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        return sb.append(")").toString();
    }

    private String getValueToPrint(Object value) {
        if (value instanceof Object[]) {
            return Arrays.toString((Object[])value);
        }
        return String.valueOf(value);
    }
}

