/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component;

import com.suncode.pwfl.component.ComponentDefinitionBuilder;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.workflow.component.ContextVariable;
import org.springframework.util.Assert;

public class ContextVariableBuilder<T extends ComponentDefinitionBuilder<T>> {
    private final ComponentDefinitionBuilder<T> componentBuilder;
    private String id;
    private LocalizedString name;
    private LocalizedString description;
    private Type<?> type;
    private boolean hidden;

    public ContextVariableBuilder(ComponentDefinitionBuilder<T> componentBuilder) {
        Assert.notNull(componentBuilder);
        this.componentBuilder = componentBuilder;
    }

    public ContextVariableBuilder<T> id(String id) {
        this.id = id;
        return this;
    }

    public ContextVariableBuilder<T> name(String name) {
        this.name = this.componentBuilder.translated(name);
        return this;
    }

    public ContextVariableBuilder<T> description(String description) {
        this.description = this.componentBuilder.translated(description);
        return this;
    }

    public ContextVariableBuilder<T> type(Type<?> type) {
        this.type = type;
        return this;
    }

    public ContextVariableBuilder<T> hidden() {
        this.hidden = true;
        return this;
    }

    public ComponentDefinitionBuilder<T> create() {
        ContextVariable parameter = new ContextVariable(this.id, this.name, this.description, this.type, this.hidden);
        return this.componentBuilder.contextVariable(parameter);
    }
}

