/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.builder;

import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class AuditBuilder {
    private ManualAuditBuilder manualBuilder;

    public static AuditBuilder getInstance() {
        return new AuditBuilder(ManualAuditBuilder.getInstance());
    }

    public AuditBuilder type(AuditTypes type) {
        return this.type(type.toString());
    }

    public AuditBuilder type(String type) {
        this.manualBuilder.type(type);
        return this;
    }

    public AuditBuilder params(Map<String, Object> params) {
        this.manualBuilder.params(params);
        return this;
    }

    public AuditBuilder success(boolean success) {
        this.manualBuilder.success(success);
        return this;
    }

    public AuditWrapper buildSuccess() {
        return this.success(true).build();
    }

    public void buildSuccess(HttpServletRequest request) {
        request.setAttribute("audit", (Object)this.buildSuccess());
    }

    public void buildFailure(HttpServletRequest request) {
        request.setAttribute("audit", (Object)this.buildFailure());
    }

    public AuditWrapper buildFailure() {
        return this.success(false).build();
    }

    public AuditWrapper build() {
        return this.manualBuilder.build();
    }

    @ConstructorProperties(value={"manualBuilder"})
    private AuditBuilder(ManualAuditBuilder manualBuilder) {
        this.manualBuilder = manualBuilder;
    }
}

