/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.web.ui.DivanteColor;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="pm_user_avatar")
@SequenceGenerator(name="pm_user_avatar_id_seq", sequenceName="pm_user_avatar_id_seq")
public class UserAvatar {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_user_avatar_id_seq")
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userid")
    private User user;
    @Lob
    private byte[] avatar;
    private boolean mini;
    @Enumerated(value=EnumType.STRING)
    private DivanteColor backgroundColor;

    public static UserAvatarBuilder builder() {
        return new UserAvatarBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public User getUser() {
        return this.user;
    }

    public byte[] getAvatar() {
        return this.avatar;
    }

    public boolean isMini() {
        return this.mini;
    }

    public DivanteColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAvatar(byte[] avatar) {
        this.avatar = avatar;
    }

    public void setMini(boolean mini) {
        this.mini = mini;
    }

    public void setBackgroundColor(DivanteColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public UserAvatar() {
    }

    @ConstructorProperties(value={"id", "user", "avatar", "mini", "backgroundColor"})
    public UserAvatar(Long id, User user, byte[] avatar, boolean mini, DivanteColor backgroundColor) {
        this.id = id;
        this.user = user;
        this.avatar = avatar;
        this.mini = mini;
        this.backgroundColor = backgroundColor;
    }

    public static class UserAvatarBuilder {
        private Long id;
        private User user;
        private byte[] avatar;
        private boolean mini;
        private DivanteColor backgroundColor;

        UserAvatarBuilder() {
        }

        public UserAvatarBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public UserAvatarBuilder user(User user) {
            this.user = user;
            return this;
        }

        public UserAvatarBuilder avatar(byte[] avatar) {
            this.avatar = avatar;
            return this;
        }

        public UserAvatarBuilder mini(boolean mini) {
            this.mini = mini;
            return this;
        }

        public UserAvatarBuilder backgroundColor(DivanteColor backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public UserAvatar build() {
            return new UserAvatar(this.id, this.user, this.avatar, this.mini, this.backgroundColor);
        }

        public String toString() {
            return "UserAvatar.UserAvatarBuilder(id=" + this.id + ", user=" + this.user + ", avatar=" + Arrays.toString(this.avatar) + ", mini=" + this.mini + ", backgroundColor=" + (Object)((Object)this.backgroundColor) + ")";
        }
    }
}

