/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.security;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;

public class DesEncrypter {
    private static Logger log = Logger.getLogger(DesEncrypter.class);
    Cipher ecipher;
    Cipher dcipher;
    byte[] salt = new byte[]{57, 59, -56, 49, 51, 53, -29, 3};
    int iterationCount = 22;

    public DesEncrypter() {
        try {
            String passPhrase = this.getPassPhrase();
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), this.salt, this.iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error((Object)"Nieprawid\u0142owy parametr algorytmu", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            log.error((Object)"Nieprawid\u0142owy parametr algorytmu", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            log.error((Object)"Nieprawid\u0142owy padding", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Nieprawid\u0142owy typ algorytmu");
        }
        catch (InvalidKeyException e) {
            log.error((Object)"Nieprawid\u0142y klucz");
        }
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return new String(new Base64().encode(enc), "UTF8");
        }
        catch (BadPaddingException e) {
            log.error((Object)"Nieprawid\u0142owy padding", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            log.error((Object)"Nieprawid\u0142owa wielko\u015b\u0107 bloku", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Nieprawid\u0142owy rodzaj kodowania", (Throwable)e);
        }
        return null;
    }

    public String decrypt(String str) {
        try {
            byte[] dec = new Base64().decode(str.getBytes("UTF8"));
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (BadPaddingException e) {
            log.error((Object)"Nieprawid\u0142owy padding", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            log.error((Object)"Nieprawid\u0142owa wielko\u015b\u0107 bloku", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Nieprawid\u0142owy rodzaj kodowania", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"B\u0142\u0105d wej\u015bcia/wyj\u015bcia", (Throwable)e);
        }
        return null;
    }

    private String getPassPhrase() {
        String key = Shark.getInstance().getProperties().getProperty("PassPhrase");
        if (key == null) {
            throw new NullPointerException("W pliku konfiguracyjnym Sharka nie zosta\u0142a podana fraza, kt\u00f3r\u0105 szyfrowane b\u0119d\u0105 has\u0142a zapisane w bazie danych");
        }
        return key;
    }
}

