/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.datachooser;

import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserDefinitionBuilder;
import com.suncode.pwfl.workflow.form.datachooser.Mapping;
import org.springframework.util.Assert;

public class MappingDefinitionBuilder {
    private final DataChooserDefinitionBuilder datachooserBuilder;
    private String id;
    private LocalizedString name;
    private LocalizedString description;
    private boolean hidden = false;
    private boolean self = false;

    public MappingDefinitionBuilder(DataChooserDefinitionBuilder datachooserBuilder) {
        Assert.notNull((Object)datachooserBuilder);
        this.datachooserBuilder = datachooserBuilder;
    }

    public MappingDefinitionBuilder id(String id) {
        this.id = id;
        return this;
    }

    public MappingDefinitionBuilder name(String name) {
        this.name = this.datachooserBuilder.translated(name);
        return this;
    }

    public MappingDefinitionBuilder description(String description) {
        this.description = this.datachooserBuilder.translated(description);
        return this;
    }

    public MappingDefinitionBuilder hidden() {
        this.hidden = true;
        return this;
    }

    public MappingDefinitionBuilder self() {
        this.self = true;
        return this;
    }

    public DataChooserDefinitionBuilder create() {
        Mapping mapping = new Mapping(this.id, this.name, this.description, this.hidden, this.self);
        return this.datachooserBuilder.mapping(mapping);
    }
}

