/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.datachooser;

import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.core.context.ContextHolder;
import com.suncode.pwfl.core.context.ContextNotActiveException;
import com.suncode.pwfl.core.context.InContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.component.ComponentQueryData;
import com.suncode.pwfl.workflow.form.datachooser.DataChooserResult;
import com.suncode.pwfl.workflow.form.datachooser.declaration.MappingDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.Assert;

public class DataChooserContext
extends WorkflowContext {
    public static final String NAME = "datachoosercontext";
    private final ComponentQueryData queryData;
    private final DataChooserResult result;
    private final List<MappingDeclaration> mappings;
    private Parameters parameters;
    private static final ContextHolder<DataChooserContext> holder = new ContextHolder("datachoosercontext", true);

    protected DataChooserContext(String processId, String activityId, ComponentQueryData queryData, DataChooserResult result, Collection<MappingDeclaration> mappings) {
        super(processId, activityId);
        Assert.notNull((Object)queryData);
        Assert.notNull((Object)result);
        this.queryData = queryData;
        this.result = result;
        this.mappings = new ArrayList<MappingDeclaration>(mappings);
    }

    @Override
    public String name() {
        return NAME;
    }

    public ComponentQueryData getQueryData() {
        return this.queryData;
    }

    public DataChooserResult getResult() {
        return this.result;
    }

    public List<MappingDeclaration> getMappings() {
        return this.mappings;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    public static boolean isActive() {
        return holder.isActive();
    }

    public static DataChooserContext current() throws ContextNotActiveException {
        return holder.current();
    }

    public static DataChooserContext activate(String processId, String activityId, ComponentQueryData queryData, DataChooserResult result, Collection<MappingDeclaration> mappings) {
        DataChooserContext.activateFunctionContext(processId, activityId);
        DataChooserContext context = new DataChooserContext(processId, activityId, queryData, result, mappings);
        holder.activate(context);
        return context;
    }

    public static void activate(String processId, String activityId, ComponentQueryData queryData, DataChooserResult result, Collection<MappingDeclaration> mappings, InContext<DataChooserContext> action) {
        DataChooserContext.activateFunctionContext(processId, activityId);
        DataChooserContext context = new DataChooserContext(processId, activityId, queryData, result, mappings);
        holder.activate(context, action);
    }

    public static DataChooserContext deactivate() {
        DataChooserContext.deactivateFunctionContext();
        return holder.remove();
    }

    @Override
    public void disableLogging() {
        DataChooserContext.current().enableLog = false;
    }

    @Override
    public void enableLogging() {
        DataChooserContext.current().enableLog = true;
    }
}

