/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.user;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.exception.UserNotFoundException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserIdCache {
    private static final Logger log = LoggerFactory.getLogger(UserIdCache.class);
    @Autowired
    private UserFinder userFinder;
    private final LoadingCache<String, Long> cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Long>(){

        public Long load(String username) {
            User user = UserIdCache.this.userFinder.findByUserName(username, new String[0]);
            if (Objects.isNull(user)) {
                log.error("User not found in database: " + username);
                return 0L;
            }
            return user.getObjectId();
        }
    });

    public Long getUserIdByUsername(String username) {
        return (Long)this.cache.get((Object)username);
    }

    public String getUsernameById(Long id) {
        return this.cache.asMap().entrySet().stream().filter(entry -> id.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElseGet(() -> {
            User user = (User)this.userFinder.get(id);
            if (user != null) {
                this.cache.put((Object)user.getUserName(), (Object)id);
                return user.getUserName();
            }
            throw new UserNotFoundException();
        });
    }
}

