/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.List;

public class PaginatedList<T> {
    private List<T> data;
    private Integer pageSize;

    public List<T> getPage(Integer pageNo) {
        if (this.data == null) {
            return Lists.newArrayList();
        }
        if (pageNo == null || this.pageSize == null) {
            return this.data;
        }
        Integer start = (pageNo - 1) * this.pageSize;
        Integer end = pageNo * this.pageSize;
        return this.getRange(start, end);
    }

    public List<T> getRange(Integer start) {
        if (this.data == null) {
            return Lists.newArrayList();
        }
        if (start == null || this.pageSize == null) {
            return this.data;
        }
        Integer end = start + this.pageSize;
        return this.getRange(start, end);
    }

    private List<T> getRange(Integer start, Integer end) {
        if (this.data.size() - 1 < start) {
            return Lists.newArrayList();
        }
        if (this.data.size() < end) {
            end = this.data.size();
        }
        return this.data.subList(start, end);
    }

    public PaginatedList() {
    }

    @ConstructorProperties(value={"data", "pageSize"})
    public PaginatedList(List<T> data, Integer pageSize) {
        this.data = data;
        this.pageSize = pageSize;
    }
}

