/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.structure;

import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.translation.configElements.PositionTranslation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="pm_positions")
@SequenceGenerator(name="pm_positions_id_seq", sequenceName="pm_positions_id_seq")
public class Position {
    public static final String JOIN_OU = "organizationalUnit";
    public static final String JOIN_HIGHER_POSITION = "higherPosition";
    public static final String JOIN_USER = "user";
    public static final String JOIN_ROLES = "roles";
    public static final String JOIN_DIRECTORED_UNITS = "directoredUnits";
    public static final String JOIN_TRANSLATIONS = "translations";
    public static final String NAME_COLUMN_NAME = "positionname";
    private String name;
    private String symbol;
    private Position higherPosition;
    private Set<OrganizationalUnit> directoredUnits;
    private User user;
    private OrganizationalUnit organizationalUnit;
    private Long id;
    private Set<Role> roles;
    public Set<Position> subPositions;
    private List<PositionTranslation> translations;

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST}, mappedBy="higherPosition")
    public Set<Position> getSubPositions() {
        return this.subPositions;
    }

    public void setSubPositions(Set<Position> subPositions) {
        this.subPositions = subPositions;
    }

    Position() {
    }

    Position(Long id) {
        this.id = id;
    }

    public Position(String name, String symbol) {
        this.setName(name);
        this.setSymbol(symbol);
    }

    @Column(name="positionname")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="positionsymbol", unique=true, nullable=false)
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="higherpositionid")
    public Position getHigherPosition() {
        return this.higherPosition;
    }

    public void setHigherPosition(Position higherPosition) {
        this.higherPosition = higherPosition;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="organizationalunitid")
    public OrganizationalUnit getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public void setOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_positions_id_seq")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="userid")
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="directorPosition")
    public Set<OrganizationalUnit> getDirectoredUnits() {
        if (this.directoredUnits == null) {
            this.directoredUnits = new HashSet<OrganizationalUnit>();
        }
        return this.directoredUnits;
    }

    public void setDirectoredUnits(Set<OrganizationalUnit> directoredUnits) {
        this.directoredUnits = directoredUnits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.symbol == null ? 0 : this.symbol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        return !(this.symbol == null ? other.symbol != null : !this.symbol.equals(other.symbol));
    }

    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinTable(name="pm_position_role", joinColumns={@JoinColumn(name="positionid")}, inverseJoinColumns={@JoinColumn(name="roleid")})
    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void addRole(Role role) {
        if (this.roles == null) {
            this.roles = new HashSet<Role>();
        }
        this.getRoles().add(role);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="translatedEntity", cascade={CascadeType.REMOVE})
    public List<PositionTranslation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<PositionTranslation> translations) {
        this.translations = translations;
    }
}

