/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.writers;

import com.suncode.plugin.datasource.xml.exceptions.XmlDataSourceException;
import com.suncode.plugin.datasource.xml.utils.Attribute;
import com.suncode.plugin.datasource.xml.utils.WriteInputParameter;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlDataWriter {
    private static final Logger log = LoggerFactory.getLogger(XmlDataWriter.class);
    private static final Translator translator = Translators.get(XmlDataWriter.class);
    private static final String SEMICOLON_CHARACTER = "SEMICOLON_CHARACTER";

    public static void writeData(String pathToFile, Map<String, WriteInputParameter> inputParameters, Map<String, String> data, boolean omitXmlDeclaration, Map<String, Attribute> attributes, String template, String handleExisting, Charset charset) throws Throwable {
        Document document = XmlDataWriter.readDocument(pathToFile, charset);
        if (handleExisting.equalsIgnoreCase("override")) {
            if (template == null) {
                throw new XmlDataSourceException(translator.getMessage("xmlDatasource.templateRequiredWhenOverriding"));
            }
            document = XmlDataWriter.buildDocumentFromTemplate(template);
        } else if (handleExisting.equalsIgnoreCase("extend") && document == null) {
            if (template == null) {
                throw new XmlDataSourceException(translator.getMessage("xmlDatasource.documentAndTemplateDoNotExist", new Object[]{pathToFile}));
            }
            document = XmlDataWriter.buildDocumentFromTemplate(template);
        }
        block12: for (Map.Entry<String, WriteInputParameter> entry : inputParameters.entrySet()) {
            WriteInputParameter params = entry.getValue();
            String textContent = data.get(entry.getKey());
            if (params == null) continue;
            switch (params.getNodeType()) {
                case "root": {
                    int length;
                    try {
                        length = Integer.parseInt(textContent);
                    }
                    catch (NumberFormatException e) {
                        throw new XmlDataSourceException(translator.getMessage("xmlDatasource.rootNodeMustContainInteger"));
                    }
                    for (int i = 0; i < length; ++i) {
                        XmlDataWriter.createAndAppendElementToDocument(document, params, attributes, "", i);
                    }
                    continue block12;
                }
                case "nonempty": {
                    if (StringUtils.isNotBlank((CharSequence)textContent)) {
                        XmlDataWriter.createAndAppendElementToDocument(document, params, attributes, textContent, -1);
                        break;
                    }
                    log.info("Ignoring empty node '" + params.getTagName() + "'");
                    break;
                }
                case "emptiable": {
                    XmlDataWriter.createAndAppendElementToDocument(document, params, attributes, textContent, -1);
                    break;
                }
                default: {
                    log.warn("Node '" + params.getTagName() + "' is of unknown type: '" + params.getNodeType() + "'!\nIgnoring that node.");
                }
            }
        }
        XmlDataWriter.writeXmlFile(document, pathToFile, omitXmlDeclaration, charset);
    }

    private static void createAndAppendElementToDocument(Document document, WriteInputParameter params, Map<String, Attribute> attributes, String textContent, int it) throws XPathExpressionException {
        if (textContent.contains(";")) {
            String[] splittedTextContent = textContent.split(";", -1);
            for (int i = 0; i < splittedTextContent.length; ++i) {
                String resolvedSemicolonTag = splittedTextContent[i].replace(SEMICOLON_CHARACTER, ";");
                Element element = XmlDataWriter.createNewElement(document, params.getTagName(), resolvedSemicolonTag);
                XmlDataWriter.applyAttributesIfAny(params.getAttributes(), attributes, element, i);
                if (StringUtils.isBlank((CharSequence)params.getArrayElementXPath())) {
                    XmlDataWriter.appendNewElementToExistingDocument(document, element, params.getXpath() + "[" + (i + 1) + "]");
                    continue;
                }
                String resolvedAbsoluteArrayElementXPath = XmlDataWriter.resolveAbsoluteArrayElementXPath(params.getXpath(), params.getArrayElementXPath() + "[" + (i + 1) + "]");
                XmlDataWriter.appendNewElementToExistingDocument(document, element, resolvedAbsoluteArrayElementXPath);
            }
        } else {
            String resolvedSemicolonTag = textContent.replace(SEMICOLON_CHARACTER, ";");
            Element element = XmlDataWriter.createNewElement(document, params.getTagName(), resolvedSemicolonTag);
            XmlDataWriter.applyAttributesIfAny(params.getAttributes(), attributes, element, it);
            XmlDataWriter.appendNewElementToExistingDocument(document, element, params.getXpath());
        }
    }

    /*
     * Exception decompiling
     */
    private static Document readDocument(String pathToFile, Charset charset) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Element createNewElement(Document document, String tagName, String content) {
        Element element = document.createElement(tagName);
        element.setTextContent(content);
        return element;
    }

    private static void applyAttributesIfAny(String attributesIds, Map<String, Attribute> attributes, Element element, int i) {
        if (StringUtils.isNotBlank((CharSequence)attributesIds)) {
            List<String> listOfAttributesIds = Arrays.asList(attributesIds.split(";", -1));
            listOfAttributesIds.forEach(id -> {
                Attribute attribute = (Attribute)attributes.get(id);
                if (attribute == null) {
                    throw new XmlDataSourceException(translator.getMessage("xmlDatasource.attributeDoesNotExist", new Object[]{id, element.getNodeName()}));
                }
                String attrValue = attribute.getValue();
                if (StringUtils.isNotBlank((CharSequence)attrValue) || ((Attribute)attributes.get(id)).isAddTo()) {
                    if (attrValue.contains(";") && i >= 0) {
                        attrValue = attrValue.split(";", -1)[i];
                    }
                    element.setAttribute(((Attribute)attributes.get(id)).getName(), attrValue);
                }
            });
        }
    }

    private static void appendNewElementToExistingDocument(Document document, Element element, String parentXpath) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile(parentXpath).evaluate(document, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            log.warn(parentXpath + " not found in document!");
            log.warn("Adding node '" + element.getTagName() + "' skipped!");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                node.appendChild(element.cloneNode(true));
                continue;
            }
            log.warn("Couldn't append element '" + element.getTagName() + "' into node '" + parentXpath + "'");
            log.warn("Node '" + parentXpath + "' is not an element node!");
        }
    }

    public static void writeXmlFile(Document document, String pathToFile, boolean omitXmlDeclaration, Charset charset) throws IOException {
        OutputFormat format = new OutputFormat(document);
        format.setOmitXMLDeclaration(omitXmlDeclaration);
        format.setIndenting(true);
        format.setIndent(4);
        format.setEncoding(charset.name());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pathToFile), charset);){
            XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
            serializer.serialize(document);
        }
    }

    private static Document buildDocumentFromTemplate(String template) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        return dBuilder.parse(new InputSource(new StringReader(template)));
    }

    private static String resolveAbsoluteArrayElementXPath(String xPath, String arrayElementXPath) {
        return arrayElementXPath + xPath.substring(xPath.lastIndexOf("/"));
    }
}

