/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.readers;

import com.suncode.plugin.datasource.xml.exceptions.XmlDataSourceException;
import com.suncode.plugin.datasource.xml.utils.OutputParameter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlDataReader {
    private static final Logger log = LoggerFactory.getLogger(XmlDataReader.class);

    public static List<Map<String, Object>> readData(String pathToFile, List<OutputParameter> outputParameters, Charset charset) {
        Document doc = XmlDataReader.readDocument(pathToFile, charset);
        Map<String, List<String>> mapOfInputParamsIdToListOfValuesFromXml = XmlDataReader.readData(outputParameters, doc);
        return XmlDataReader.result(mapOfInputParamsIdToListOfValuesFromXml, outputParameters);
    }

    /*
     * Exception decompiling
     */
    public static Document readDocument(String pathToFile, Charset charset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Map<String, List<String>> readData(List<OutputParameter> outputParameters, Document doc) {
        return outputParameters.stream().collect(Collectors.toMap(parameter -> parameter.getId(), parameter -> XmlDataReader.getParameterValue(doc, parameter)));
    }

    private static List<String> getParameterValue(Document document, OutputParameter parameter) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodeList = (NodeList)xPath.compile(parameter.getXPath()).evaluate(document, XPathConstants.NODESET);
            return IntStream.range(0, nodeList.getLength()).mapToObj(nodeNo -> {
                String childValue = "";
                childValue = StringUtils.isBlank((CharSequence)parameter.getChildNodeName()) ? nodeList.item(nodeNo).getTextContent() : XmlDataReader.getChildValue(nodeList.item(nodeNo), parameter.getChildNodeName());
                return childValue.replace(";", ":");
            }).collect(Collectors.toList());
        }
        catch (XPathExpressionException e) {
            throw new XmlDataSourceException(e);
        }
    }

    private static String getChildValue(Node item, String childName) {
        NodeList childNodes = item.getChildNodes();
        String childValue = "";
        for (int childNo = 0; childNo < childNodes.getLength(); ++childNo) {
            if (!childNodes.item(childNo).getNodeName().equals(childName)) continue;
            childValue = childNodes.item(childNo).getTextContent();
        }
        return childValue;
    }

    private static List<Map<String, Object>> result(Map<String, List<String>> mapOfInputParamsIdToListOfValuesFromXml, List<OutputParameter> outputParameters) {
        int maxLength = mapOfInputParamsIdToListOfValuesFromXml.entrySet().stream().map(entry -> ((List)entry.getValue()).size()).max(Integer::compare).get();
        return IntStream.range(0, maxLength).mapToObj(i -> outputParameters.stream().collect(Collectors.toMap(parameter -> parameter.getId(), parameter -> {
            try {
                return ((List)mapOfInputParamsIdToListOfValuesFromXml.get(parameter.getId())).get(i);
            }
            catch (IndexOutOfBoundsException e) {
                return "";
            }
        }))).collect(Collectors.toList());
    }
}

