/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.erasers;

import com.suncode.plugin.datasource.xml.exceptions.XmlDataSourceException;
import com.suncode.plugin.datasource.xml.readers.XmlDataReader;
import com.suncode.plugin.datasource.xml.writers.XmlDataWriter;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlDataEraser {
    private static final Logger log = LoggerFactory.getLogger(XmlDataEraser.class);

    public static void eraseData(String pathToFile, String xpathToDelete, Map<String, String> data, Charset charset) throws Throwable {
        Document document = XmlDataReader.readDocument(pathToFile, charset);
        for (Map.Entry<String, String> parameter : data.entrySet()) {
            xpathToDelete = xpathToDelete.replace("{" + parameter.getKey() + "}", parameter.getValue());
        }
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.compile(xpathToDelete).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 || node.getParentNode() != null) {
                    node.getParentNode().removeChild(node);
                    continue;
                }
                log.warn("Cannot delete node '" + xpathToDelete + "' because it is a root node!");
            }
        }
        catch (XPathExpressionException e) {
            throw new XmlDataSourceException(e);
        }
        XmlDataWriter.writeXmlFile(document, pathToFile, true, charset);
    }
}

