/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.controllers;

import com.suncode.plugin.datasource.xml.TranslatorWrapper;
import com.suncode.plugin.datasource.xml.entities.XmlTemplate;
import com.suncode.plugin.datasource.xml.services.XmlTemplatesService;
import com.suncode.pwfl.datasource.rest.SortDto;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.web.support.ajax.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"templates"})
public class XmlTemplatesController {
    private static final Logger log = LoggerFactory.getLogger(XmlTemplatesController.class);
    @Autowired
    private XmlTemplatesService xmlTemplatesService;
    @Autowired
    private TranslatorWrapper t;

    @Transactional
    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<XmlTemplate> getTemplates(@RequestParam(required=false) String query, @RequestParam(required=false) Integer start, @RequestParam(required=false) Integer limit, SortDto sort) {
        return this.xmlTemplatesService.getTemplates(query, sort.getSorter(), start, limit);
    }

    @Transactional
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public RestResult createTemplate(@RequestBody XmlTemplate template) {
        log.debug("Creating template: " + template);
        if (this.xmlTemplatesService.getTemplate(template.getId()) != null) {
            return new RestResult(false, this.t.getMessage("xmlDatasource.templateExists", template.getName()));
        }
        this.xmlTemplatesService.saveTemplate(template);
        return new RestResult(true, this.t.getMessage("xmlDatasource.templateCreated"));
    }

    @Transactional
    @RequestMapping(value={"{templateId}"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult modifyTemplate(@PathVariable String templateId, @RequestBody XmlTemplate modifiedTemplate) {
        log.debug("Updating template: " + templateId + " | " + modifiedTemplate);
        XmlTemplate template = this.xmlTemplatesService.getTemplate(templateId);
        if (template == null) {
            return new RestResult(false, this.t.getMessage("xmlDatasource.templateNotExists", templateId));
        }
        template.setName(modifiedTemplate.getName());
        template.setTemplate(modifiedTemplate.getTemplate());
        this.xmlTemplatesService.updateTemplate(template);
        return new RestResult(true, this.t.getMessage("xmlDatasource.templateModified"));
    }

    @Transactional
    @RequestMapping(value={"{templateId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult deleteTemplate(@PathVariable String templateId) {
        log.debug("Deleting template: " + templateId);
        XmlTemplate template = this.xmlTemplatesService.getTemplate(templateId);
        if (template != null) {
            this.xmlTemplatesService.deleteTemplate(template);
        }
        return new RestResult(true, this.t.getMessage("xmlDatasource.templateDeleted"));
    }
}

