/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.component;

import com.suncode.plugin.datasource.xml.erasers.XmlDataEraser;
import com.suncode.plugin.datasource.xml.readers.XmlDataReader;
import com.suncode.plugin.datasource.xml.services.XmlTemplatesService;
import com.suncode.plugin.datasource.xml.utils.Attribute;
import com.suncode.plugin.datasource.xml.utils.AttributeParameter;
import com.suncode.plugin.datasource.xml.utils.OutputParameter;
import com.suncode.plugin.datasource.xml.utils.ResultsTransformer;
import com.suncode.plugin.datasource.xml.utils.WriteInputParameter;
import com.suncode.plugin.datasource.xml.writers.XmlDataWriter;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.datasource.AbstractDataSourceInstance;
import com.suncode.pwfl.datasource.DataSourceOperation;
import com.suncode.pwfl.datasource.DataSourceParameter;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Pagination;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class XmlDataSource
extends AbstractDataSourceInstance {
    private static final Logger log = LoggerFactory.getLogger(XmlDataSource.class);
    private static final String PLUSWORKFLOW_HOME_TAG = "{PWFL_HOME}";
    private static final String PLUSWORKFLOW_WORKING_DIRECTORY_TAG = "{WORKING_DIRECTORY}";
    private final XmlTemplatesService xmlTemplatesService;
    private final String pathToFile;
    private final String xmlTemplate;
    private final String handleExisting;
    private final String xpathToDelete;
    private final Boolean omitXmlDeclaration;
    private final Map<String, String> pathParameters;
    private final Map<String, AttributeParameter> attributesParameters;
    private final Map<String, String> deleteInputParameters;
    private final Map<String, WriteInputParameter> writeInputParameters;
    private final List<OutputParameter> outputParameters;
    private final Charset charset;

    XmlDataSource(XmlTemplatesService xmlTemplateService, Parameters parameters) {
        this.xmlTemplatesService = xmlTemplateService;
        this.charset = Charset.forName((String)parameters.get("charsetName", String.class));
        this.pathToFile = this.buildPathToFile((String)parameters.get("pathToFile", String.class));
        this.xmlTemplate = (String)parameters.get("xmlTemplate", String.class);
        this.handleExisting = (String)parameters.get("handleExisting", String.class);
        this.xpathToDelete = (String)parameters.get("xpathToDelete", String.class);
        this.omitXmlDeclaration = (Boolean)parameters.get("omitXmlDeclaration", Boolean.class);
        this.pathParameters = this.buildParams((String[])parameters.get("pathParametersId", String[].class), (String[])parameters.get("pathParametersName", String[].class));
        this.attributesParameters = this.buildAttributesParameters((String[])parameters.get("attributesParametersId", String[].class), (String[])parameters.get("attributesParametersName", String[].class), (Boolean[])parameters.get("attributesParametersAddEmpty", Boolean[].class));
        this.deleteInputParameters = this.buildParams((String[])parameters.get("deleteInputParametersId", String[].class), (String[])parameters.get("deleteInputParametersName", String[].class));
        this.writeInputParameters = this.buildWriteInputParameters((String[])parameters.get("writeInputParametersId", String[].class), (String[])parameters.get("writeInputParametersTagName", String[].class), (String[])parameters.get("writeInputParametersParentXPath", String[].class), (String[])parameters.get("writeInputParametersArrayElementXPath", String[].class), (String[])parameters.get("writeInputParametersAttributes", String[].class), (String[])parameters.get("writeInputParametersNodeType", String[].class));
        this.outputParameters = this.buildOutputParameters((String[])parameters.get("outputParametersId", String[].class), (String[])parameters.get("outputParametersName", String[].class), (String[])parameters.get("outputParametersXPath", String[].class), (String[])parameters.get("outputParametersChildNodeName", String[].class));
    }

    public CountedResult<Map<String, Object>> execute(Map<String, String> parameters, Map<String, String> filters, Pagination pagination) {
        String resolvedPathToFile = this.resolvePathWithParameters(parameters);
        if (this.getOperation() != DataSourceOperation.READ) {
            log.info("Resolved path to file: " + resolvedPathToFile);
        }
        switch (this.getOperation()) {
            case DELETE: {
                XmlDataEraser.eraseData(resolvedPathToFile, this.xpathToDelete, parameters, this.charset);
                return new CountedResult(0L, new ArrayList());
            }
            case INSERT: {
                Map<String, Attribute> attributes = this.extractAttributes(this.attributesParameters, parameters);
                String template = this.xmlTemplate == null ? null : this.xmlTemplatesService.getTemplate(this.xmlTemplate).getTemplate();
                XmlDataWriter.writeData(resolvedPathToFile, this.writeInputParameters, parameters, this.omitXmlDeclaration, attributes, template, this.handleExisting, this.charset);
                return new CountedResult(0L, new ArrayList());
            }
            case READ: {
                List<Map<String, Object>> result = XmlDataReader.readData(resolvedPathToFile, this.outputParameters, this.charset);
                if (filters != null) {
                    ResultsTransformer.applyFilters(result, filters);
                }
                if (pagination != null) {
                    ResultsTransformer.applySort(result, pagination.getSorter());
                }
                List<Map<String, Object>> resultData = pagination == null ? result : result.subList(pagination.getStart(), Math.min(pagination.getStart() + pagination.getLimit(), result.size()));
                return new CountedResult((long)result.size(), resultData);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Set<DataSourceParameter> getInputParameters() {
        LinkedHashSet<DataSourceParameter> inputParameters = new LinkedHashSet<DataSourceParameter>();
        switch (this.getOperation()) {
            case DELETE: {
                this.pathParameters.forEach((id, name) -> inputParameters.add(new DataSourceParameter(id, name)));
                this.deleteInputParameters.forEach((id, name) -> inputParameters.add(new DataSourceParameter(id, name)));
                return inputParameters;
            }
            case INSERT: {
                this.pathParameters.forEach((id, name) -> inputParameters.add(new DataSourceParameter(id, name)));
                this.attributesParameters.forEach((id, param) -> inputParameters.add(new DataSourceParameter(id, param.getName())));
                this.writeInputParameters.forEach((key, value) -> inputParameters.add(new DataSourceParameter(key, "[" + key + "] " + value.getTagName())));
                return inputParameters;
            }
            case READ: {
                this.pathParameters.forEach((id, name) -> inputParameters.add(new DataSourceParameter(id, name)));
                return inputParameters;
            }
        }
        return inputParameters;
    }

    public Set<DataSourceParameter> getOutputParameters() {
        return this.outputParameters.stream().map(parameter -> new DataSourceParameter(parameter.getId(), parameter.getName())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private String buildPathToFile(String pathToFile) {
        if (pathToFile.contains(PLUSWORKFLOW_HOME_TAG) && pathToFile.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            throw new IllegalArgumentException("PathToFile only needs one {PWFL_HOME} or {WORKING_DIRECTORY} tag");
        }
        if (pathToFile.contains(PLUSWORKFLOW_HOME_TAG)) {
            return pathToFile.replace(PLUSWORKFLOW_HOME_TAG, System.getProperty("plusworkflow.home"));
        }
        if (pathToFile.contains(PLUSWORKFLOW_WORKING_DIRECTORY_TAG)) {
            return pathToFile.replace(PLUSWORKFLOW_WORKING_DIRECTORY_TAG, SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY));
        }
        return pathToFile;
    }

    private Map<String, String> buildParams(String[] ids, String[] names) {
        Assert.isTrue((ids.length == names.length ? 1 : 0) != 0, (String)"Input parameters length mismatch!");
        return IntStream.range(0, ids.length).boxed().collect(Collectors.toMap(i -> ids[i], i -> names[i], (existing, candidate) -> existing, LinkedHashMap::new));
    }

    private Map<String, AttributeParameter> buildAttributesParameters(String[] ids, String[] names, Boolean[] addEmpty) {
        Assert.isTrue((ids.length == names.length && ids.length == addEmpty.length ? 1 : 0) != 0, (String)"Attributes parameters length mismatch!");
        return IntStream.range(0, ids.length).boxed().collect(Collectors.toMap(i -> ids[i], i -> new AttributeParameter(names[i], addEmpty[i]), (existing, candidate) -> existing, LinkedHashMap::new));
    }

    private Map<String, WriteInputParameter> buildWriteInputParameters(String[] ids, String[] tagNames, String[] xpaths, String[] arrayElementXPaths, String[] attributes, String[] nodeTypes) {
        String[] finalArrayElementXPaths = arrayElementXPaths.length == 0 ? new String[ids.length] : arrayElementXPaths;
        Assert.isTrue((ids.length == tagNames.length && ids.length == xpaths.length && ids.length == finalArrayElementXPaths.length && ids.length == attributes.length && ids.length == nodeTypes.length ? 1 : 0) != 0, (String)"Input parameters length mismatch!");
        return IntStream.range(0, tagNames.length).boxed().collect(Collectors.toMap(i -> ids[i], i -> new WriteInputParameter(tagNames[i], xpaths[i], finalArrayElementXPaths[i], attributes[i], nodeTypes[i]), (existing, candidate) -> existing, LinkedHashMap::new));
    }

    private List<OutputParameter> buildOutputParameters(String[] ids, String[] names, String[] xpaths, String[] childNodeNames) {
        String[] finalChildNodeNames = childNodeNames.length == 0 ? new String[ids.length] : childNodeNames;
        Assert.isTrue((ids.length == names.length && ids.length == xpaths.length && xpaths.length == finalChildNodeNames.length ? 1 : 0) != 0, (String)"Output parameters length mismatch!");
        return IntStream.range(0, ids.length).mapToObj(i -> new OutputParameter(ids[i], names[i], xpaths[i], finalChildNodeNames[i])).collect(Collectors.toList());
    }

    private String resolvePathWithParameters(Map<String, String> data) {
        String resolvedPathToFile = this.pathToFile;
        for (String id : this.pathParameters.keySet()) {
            resolvedPathToFile = resolvedPathToFile.replace("{" + id + "}", data.remove(id));
        }
        return resolvedPathToFile;
    }

    private Map<String, Attribute> extractAttributes(Map<String, AttributeParameter> attributesParameters, Map<String, String> data) {
        return attributesParameters.entrySet().stream().collect(Collectors.toMap(parameter -> (String)parameter.getKey(), parameter -> new Attribute(((AttributeParameter)attributesParameters.get(parameter.getKey())).getName(), (String)data.remove(parameter.getKey()), ((AttributeParameter)attributesParameters.get(parameter.getKey())).isAddEmpty())));
    }
}

