XMLDS = {
	t: PW.I18N.createT('com.suncode.plugin-xml-datasources')
}

PW.DataSources.register('xmlDatasource', {
	buildParams: function (form, options) {
		this.buildFileForm(form);
		switch (options.operation) {
			case 'READ':
				this.buildReadForm(form);
				break;
			case 'UPDATE':
				break;
			case 'INSERT':
				this.buildWriteForm(form);
				break;
			case 'DELETE':
				this.buildDeleteForm(form);
				break;
		}
	},
	buildFileForm: function(form) {
		var row = form.addRow()
		row.addField('pathToFile');
		row.addCombobox({
			id: 'charsetName',
			valueField: 'name',
			displayField: 'name',
			queryCaching: false,
			remote: {
				url: Suncode.getAbsolutePath('plugin/com.suncode.plugin-xml-datasources/form/charsets'),
				fields: ['name'],
				remoteSort: true,
				pageSize: 20
			},
			sort: [{
				property: 'name',
				direction: 'ASC'
			}],
		});
	},
	buildReadForm: function (form) {
		var pathParametersTable = form.addTable();
		pathParametersTable.addField('pathParametersId');
		pathParametersTable.addField('pathParametersName');
		var outputParametersTable = form.addTable();
		outputParametersTable.addField('outputParametersId');
		outputParametersTable.addField('outputParametersName');
		outputParametersTable.addField('outputParametersXPath');
		outputParametersTable.addField('outputParametersChildNodeName');
	},

	buildWriteForm: function (form) {
		var templatesRow = form.addRow({ id: 'templatesRow' });
		templatesRow.addCombobox({
			id: 'xmlTemplate',
			valueField: 'id',
			displayField: 'name',
			queryCaching: false,
			remote: {
				url: PW.getAbsolutePath('/plugin/com.suncode.plugin-xml-datasources/templates'),
				fields: ['id', 'name'],
				remoteSort: true,
			},
			sort: [
				{
					property: 'name',
					direction: 'ASC',
				},
			],
		});
		templatesRow.addButton({
			id: 'createTemplatesButton',
			text: XMLDS.t('xmlDatasource.createTemplates'),
			handler: function () {
				this.showManageTemplatesWindow(templatesRow, false);
			}.bind(this),
		});
		templatesRow.addButton({
			id: 'modifyTemplatesButton',
			text: XMLDS.t('xmlDatasource.modifyTemplates'),
			handler: function () {
				this.showManageTemplatesWindow(templatesRow, true);
			}.bind(this),
		});
		form.addCombobox({
			id: 'handleExisting',
			valueField: 'id',
			displayField: 'display',
			fields: [
				{ name: 'id', type: 'string' },
				{ name: 'display', type: 'string' },
			],
			values: [
				{ id: 'extend', display: XMLDS.t('xmlDatasource.extend') },
				{ id: 'override', display: XMLDS.t('xmlDatasource.overwrite') },
			],
		});
		var handleExisting = form.form.items.get('handleExisting');
		if (handleExisting.getValue() === null) {
			handleExisting.setValue('extend');
		}
		form.addField('omitXmlDeclaration');
		var pathParametersTable = form.addTable();
		pathParametersTable.addField('pathParametersId');
		pathParametersTable.addField('pathParametersName');
		var attributesParametersTable = form.addTable();
		attributesParametersTable.addField('attributesParametersId');
		attributesParametersTable.addField('attributesParametersName');
		attributesParametersTable.addField('attributesParametersAddEmpty');
		var inputParametersTable = form.addTable();
		inputParametersTable.addField('writeInputParametersId');
		inputParametersTable.addField('writeInputParametersTagName');
		inputParametersTable.addField('writeInputParametersParentXPath');
		inputParametersTable.addField('writeInputParametersArrayElementXPath');
		inputParametersTable.addField('writeInputParametersAttributes');
		inputParametersTable.addCombobox({
			id: 'writeInputParametersNodeType',
			valueField: 'id',
			displayField: 'display',
			fields: [
				{ name: 'id', type: 'string' },
				{ name: 'display', type: 'string' },
			],
			values: [
				{ id: 'root', display: 'Root' },
				{ id: 'nonempty', display: 'Nonempty' },
				{ id: 'emptiable', display: 'Emptiable' },
			],
		});
	},

	buildDeleteForm: function (form) {
		form.addField('xpathToDelete');
		var pathParametersTable = form.addTable();
		pathParametersTable.addField('pathParametersId');
		pathParametersTable.addField('pathParametersName');
		var inputParametersTable = form.addTable();
		inputParametersTable.addField('deleteInputParametersId');
		inputParametersTable.addField('deleteInputParametersName');
	},

	showManageTemplatesWindow: function (row, modify) {
		Ext4.create('Ext4.window.Window', {
			title: modify ? XMLDS.t('xmlDatasource.editTemplates') : XMLDS.t('xmlDatasource.addTemplates'),
			width: modify ? 600 : 500,
			modal: true,
			frame: false,
			layout: 'fit',
			autoShow: true,
			items: [
				{
					xtype: 'form',
					layout: 'form',
					frame: false,
					border: false,
					bodyPadding: 10,
					defaults: {
						labelWidth: 150,
					},
					items: [
						{
							xtype: 'combo',
							name: 'peekTemplate',
							fieldLabel: XMLDS.t('xmlDatasource.chooseTemplate'),
							queryCaching: false,
							store: Ext4.create('Ext4.data.Store', {
								fields: ['id', 'name', 'template'],
								remoteSort: true,
								pageSize: 20,
								proxy: {
									type: 'ajax',
									url: PW.getAbsolutePath('/plugin/com.suncode.plugin-xml-datasources/templates'),
									reader: {
										type: 'json',
										root: 'data',
										totalProperty: 'total',
									},
								},
								sorters: [
									{
										property: 'name',
										direction: 'ASC',
									},
								],
							}),
							pageSize: 20,
							minChars: 0,
							queryMode: 'remote',
							displayField: 'name',
							valueField: 'id',
							submitValue: false,
							padding: '0 0 10 0',
							listeners: {
								select: function (combo, record) {
									var form = combo.up('form').getForm();
									if (!modify) {
										record[0].data.id = '';
										record[0].data.name = '';
									}
									form.setValues(record[0].data);
								},
							},
						},
						{
							xtype: 'box',
							autoEl: 'div',
							height: 5,
						},
						{
							xtype: 'textfield',
							name: 'id',
							fieldLabel: XMLDS.t('xmlDatasource.id'),
							allowBlank: false,
							hidden: modify,
						},
						{
							xtype: 'textfield',
							name: 'name',
							fieldLabel: XMLDS.t('xmlDatasource.name'),
							allowBlank: false,
						},
						{
							xtype: 'textarea',
							name: 'template',
							fieldLabel: XMLDS.t('xmlDatasource.template'),
							allowBlank: false,
							minHeight: 200
						},
						{
							id: 'upload-template',
							xtype: 'filefield',
							buttonText: '',
							buttonOnly: true,
							listeners: {
								change: function (button) {
									var fileInput = button.fileInputEl.dom;
									var reader = new FileReader();
									reader.onload = function () {
										button.container.down('[name=template]').dom.value = this.result;
									}
									var file = fileInput.files[0];
									if (file.type === 'text/xml') {
										reader.readAsText(file);
										PW.ui.Message.success(XMLDS.t('xmlDatasource.templateLoaded'))
									} else {
										PW.ui.Message.error(XMLDS.t('xmlDatasource.badFileType'));
									}
								}
							}
						},
						{
							xtype: 'box',
							autoEl: 'div',
							height: 20,
						}
					]
				}
			],
			buttons: [
				{
					text: XMLDS.t('xmlDatasource.createTemplate'),
					handler: function (button) {
						var win = button.up('window');
						win.createOrModifyTemplate(win, row);
					},
					hidden: modify,
				},
				{
					text: XMLDS.t('xmlDatasource.modifyTemplate'),
					handler: function (button) {
						var win = button.up('window'),
							templateId = win.down('[name=id]').getValue();
						win.createOrModifyTemplate(win, row, templateId);
					},
					hidden: !modify,
				},
				{
					text: XMLDS.t('xmlDatasource.deleteTemplate'),
					handler: function (button) {
						Ext4.MessageBox.confirm(
							XMLDS.t('xmlDatasource.deleteTemplatesTitle'),
							XMLDS.t('xmlDatasource.deleteTemplatesConfirm'),
							function (btn) {
								if (btn === 'yes') {
									var win = button.up('window'),
										templateId = win.down('[name=id]').getValue();
									win.deleteTemplate(win, row, templateId);
								}
							}
						);
					},
					hidden: !modify,
				},
				{
					text: PW.t('cancel'),
					handler: function (button) {
						button.up('window').close();
					},
				},
			],
			createOrModifyTemplate: function (win, row, templateId) {
				var url = '/plugin/com.suncode.plugin-xml-datasources/templates';
				if (templateId) {
					url += '/' + templateId;
				}
				var form = this.down('form');
				var values = form.getValues();
				if (form.isValid()) {
					form.mask();
					Ext4.Ajax.request({
						url: PW.getAbsolutePath(url),
						method: 'POST',
						jsonData: Ext4.encode(values),
						failure: function (resp) {
							PW.ui.Message.error(XMLDS.t('xmlDatasource.unknownException'));
							form.unmask();
						},
						success: function (resp) {
							var response = Ext4.decode(resp.responseText);
							if (response.success) {
								PW.ui.Message.success(response.message);
								win.close();
							} else {
								PW.ui.Message.error(response.message);
								form.unmask();
							}
						},
					});
				}
			},
			deleteTemplate: function (win, row, templateId) {
				var url = '/plugin/com.suncode.plugin-xml-datasources/templates/' + templateId;
				var form = this.down('form');
				if (form.isValid()) {
					form.mask();
					Ext4.Ajax.request({
						url: PW.getAbsolutePath(url),
						method: 'DELETE',
						failure: function (resp) {
							PW.ui.Message.error(XMLDS.t('xmlDatasource.unknownException'));
							form.unmask();
						},
						success: function (resp) {
							var response = Ext4.decode(resp.responseText);
							if (response.success) {
								PW.ui.Message.success(response.message);
								win.close();
							} else {
								PW.ui.Message.error(response.message);
								form.unmask();
							}
						},
					});
				}
			}
		});
	}
});
