/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.services;

import com.suncode.plugin.datasource.xml.dao.XmlTemplateDao;
import com.suncode.plugin.datasource.xml.entities.XmlTemplate;
import com.suncode.plugin.datasource.xml.services.XmlTemplatesService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.support.hibernate.criterion.Criterion;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.BaseFinderImpl;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="templatesService")
@Transactional
public class XmlTemplatesServiceImpl
extends BaseFinderImpl<XmlTemplate, String, XmlTemplateDao>
implements XmlTemplatesService {
    @Autowired
    public void setDao(XmlTemplateDao dao) {
        this.dao = dao;
    }

    @Override
    public CountedResult<XmlTemplate> getTemplates(String query, Sorter sorter, Integer start, Integer limit) {
        HibernateCriteria criteria = HibernateCriteria.forClass(XmlTemplate.class);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            criteria.add((Criterion)Restrictions.disjunction().add(Restrictions.ilike((String)"id", (Object)("%" + query + "%"))).add(Restrictions.ilike((String)"name", (Object)("%" + query + "%"))));
        }
        List xmlTemplates = ((XmlTemplateDao)this.dao).findByCriteria(criteria);
        CountedResult result = new CountedResult();
        result.setTotal((long)xmlTemplates.size());
        if (xmlTemplates.size() >= start) {
            result.setData(xmlTemplates.subList(start, Integer.min(xmlTemplates.size(), start + limit)));
        } else {
            result.setData(Collections.emptyList());
        }
        return result;
    }

    @Override
    public XmlTemplate getTemplate(String id) {
        return (XmlTemplate)((XmlTemplateDao)this.dao).get((Serializable)((Object)id));
    }

    @Override
    public void saveTemplate(XmlTemplate template) {
        ((XmlTemplateDao)this.dao).save(template);
    }

    @Override
    public void updateTemplate(XmlTemplate template) {
        ((XmlTemplateDao)this.dao).update(template);
    }

    @Override
    public void deleteTemplate(XmlTemplate template) {
        ((XmlTemplateDao)this.dao).delete(template);
    }
}

