/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.controllers;

import com.suncode.plugin.datasource.xml.charsets.XmlCharsetSupported;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"form"})
public class DataSourceFormController {
    @RequestMapping(value={"charsets"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getCharsets(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        List comboboxList = Arrays.stream(XmlCharsetSupported.values()).filter(charset -> this.charsetFilter(query, (XmlCharsetSupported)((Object)charset))).sorted((o1, o2) -> o1.getCharsetName().compareTo(o2.getCharsetName())).map(charset -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", charset.getCharsetName());
            return map;
        }).collect(Collectors.toList());
        int totalResult = comboboxList.size();
        Long startL = Long.valueOf(start);
        CountedResult result = new CountedResult();
        Long limitL = Long.valueOf(limit);
        result.setData(totalResult > limitL.intValue() ? comboboxList.subList(startL.intValue(), Math.min(startL.intValue() + limitL.intValue(), comboboxList.size())) : comboboxList);
        result.setTotal((long)totalResult);
        return result;
    }

    private boolean charsetFilter(String query, XmlCharsetSupported charset) {
        return StringUtils.isBlank((CharSequence)query) || StringUtils.isNotBlank((CharSequence)query) && charset.getCharsetName().toUpperCase().contains(query.toUpperCase());
    }
}

