/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.xml.component;

import com.suncode.pwfl.datasource.DataSourceValidateException;
import com.suncode.pwfl.datasource.DataSourceValidator;
import com.suncode.pwfl.datasource.dao.DataSourceDeclaration;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.workflow.component.declaration.ParameterDeclaration;
import com.suncode.pwfl.workflow.component.declaration.ParameterValue;
import java.util.List;

public class XmlDataSourceValidator
implements DataSourceValidator {
    private final Translator translator = Translators.get(XmlDataSourceValidator.class);

    public void validate(DataSourceDeclaration declaration) {
        switch (declaration.getOperation()) {
            case READ: {
                ParameterDeclaration pathParametersId = declaration.getParameter("pathParametersId");
                ParameterDeclaration outputParametersId = declaration.getParameter("outputParametersId");
                if (this.checkIfValuesNotUnique((List)pathParametersId.getValue())) {
                    throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniquePathParametersIds"));
                }
                if (!this.checkIfValuesNotUnique((List)outputParametersId.getValue())) break;
                throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniqueOutputParametersIds"));
            }
            case INSERT: {
                ParameterDeclaration pathParametersId = declaration.getParameter("pathParametersId");
                ParameterDeclaration attributesParametersId = declaration.getParameter("attributesParametersId");
                ParameterDeclaration attributesParametersName = declaration.getParameter("attributesParametersName");
                ParameterDeclaration writeInputParametersId = declaration.getParameter("writeInputParametersId");
                if (this.checkIfValuesNotUnique((List)pathParametersId.getValue())) {
                    throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniquePathParametersIds"));
                }
                if (this.checkIfValuesNotUnique((List)attributesParametersId.getValue())) {
                    throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniqueAttributeParametersIds"));
                }
                if (this.checkIfValuesNotUnique((List)attributesParametersName.getValue())) {
                    throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniqueAttributesParametersNames"));
                }
                if (!this.checkIfValuesNotUnique((List)writeInputParametersId.getValue())) break;
                throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniqueWriteInputParametersIds"));
            }
            case DELETE: {
                ParameterDeclaration pathParametersId = declaration.getParameter("pathParametersId");
                ParameterDeclaration deleteInputParametersId = declaration.getParameter("deleteInputParametersId");
                if (this.checkIfValuesNotUnique((List)pathParametersId.getValue())) {
                    throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniquePathParametersIds"));
                }
                if (!this.checkIfValuesNotUnique((List)deleteInputParametersId.getValue())) break;
                throw new DataSourceValidateException(this.translator.getMessage("xmlDatasource.validator.uniqueDeleteInputParametersIds"));
            }
            case UPDATE: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private boolean checkIfValuesNotUnique(List<ParameterValue> parameterValues) {
        return (long)parameterValues.size() != parameterValues.stream().map(ParameterValue::getValue).distinct().count();
    }
}

