PW.FormActions.create('vendor.checker.entities-info.action', {
	formInit() {
		this.variableSet = VariableSetService.get(this.get("tableId"));
	},

	variableSetInit: function (table) {
		this.variableSet = VariableSetService.get(table.getId());
	},

	dtButtonInit: function (button) {
		this.variableSet = VariableSetService
			.get(button.variableSet.getId());
	},
	enable: function () {
		if (this.target.type == 'FORM') {
			this.getEntitiesInfo()
		}
	},

	disable: function () {
	},
	defaultActions: {
		dtButton: function (button) {
			this.getEntitiesInfo();
		}
	},
	getEntitiesInfo: function () {
		var searchValues = this.get("nipsOrNrbs");
		if (searchValues == undefined || searchValues.length < 1) {
			return;
		}
		var searchType = this.get("searchType");
		var entityParamsName = this.get("entityParamsName");
		var variablesIds = [];
		jQuery(this.get('variables')).each(
			function (index, item) {
				variablesIds.push(item.getId());
			});

		var reqDates = []
		jQuery(this.get("dates")).each(
			function (index, item) {
				reqDates.push(item ? item.dateFormat('Y-m-d') : "");
			});
		var processingStatus = this.get("processingStatus");
		var isOnComment = this.get("comment");
		var me = this;
		FormService.mask();
		jQuery.ajax({
			url: 'plugin/com.suncode.plugin-vendor.checker/api/entities/',
			type: 'POST',
			contentType: "application/x-www-form-urlencoded",
			data: {
				nipsOrNrbs: searchValues,
				dates: reqDates,
				searchType: searchType,
				entityParamsName: entityParamsName
			},
			success: function (responseData) {
				if (devMode) {
					console.log(responseData);
				}
				me.clearVariables();
				me.rewriteData(responseData.data)
				if (isOnComment && !responseData.success) {
					CommentService.add(responseData.message);
				}
				if (processingStatus) { processingStatus.setValue(responseData.message) }
				FormService.unmask();
			},
			error: function () {
				FormService.unmask();
				MessageService.showFailure(VENDOR.t('server.error'));
				return false;
			}
		});
	},
	rewriteData(data) {
		if (data) {
			var variables = this.get("variables");
			var entityParamsNames = this.get("entityParamsName");
			for (var rowIndex = 0; rowIndex < data.length; rowIndex++) {
				for (var index = 0; index < variables.length; index++) {
					VariableSetService.setValue(this.variableSet, rowIndex, variables[index].getId(), data[rowIndex][entityParamsNames[index]]);
				}
			}
		}
	},
	clearVariables() {
		var variables = this.get("variables");
		for (var index = 0; index < variables.length; index++) {
			variables[index].setValue([]);
		}
	}
});