PW.FormActions.create('vendor.checker.entity-info.action', {
    enable: function () {
        if (this.target.type == 'FORM') {
            this.getEntityInfo();
        }
    },

    defaultActions: {
        button: function (button) {
            this.getEntityInfo();
        },
        variable: function (variable, newValue, oldValue) {
            this.getEntityInfo(newValue);
        },
    },
    getEntityInfo: function (newValue) {
        var me = this;
        var date = this.get("date");
        var statusVar = this.get("processingStatus");
        var isOnComment = this.get("comment");
        FormService.mask();
        jQuery.ajax({
            type: "GET",
            data: {
                nipNrb: newValue ? newValue : this.get("nipOrNrb"),
                date: date ? date.dateFormat('Y-m-d') : null,
                searchType: this.get("searchType")
            },
            url: "plugin/com.suncode.plugin-vendor.checker/api/entity",
        })
            .done(function (responseData) {
                me.clearVariables();
                me.rewriteData(responseData.data)
                if (isOnComment && !responseData.success) {
                    CommentService.add(responseData.message);
                }
                if (statusVar) {
                    statusVar.setValue(responseData.message);
                }
            })
            .fail(function (jqXHR, textStatus, errorThrown) {
                Logger.error("Request failed.");
                MessageService.showFailure(errorThrown);
            })
            .always(function () {
                FormService.unmask();
            });
    },
    rewriteData(data) {
        if (data) {
            var variables = this.get("variables");
            var entityParamsNames = this.get("entityParamsName");
            for (var index = 0; index < variables.length; index++) {
                variables[index].setValue(data[entityParamsNames[index]]);
            }
        }
    },
    clearVariables() {
        var variables = this.get("variables");
        for (var index = 0; index < variables.length; index++) {
            if(variables[index].type.isArray){
                variables[index].setValue([]);
            }else{
                variables[index].setValue(null);
            }
        }
    }
})