/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.validators;

import com.suncode.plugin.vendor.checker.actions.categories.Categories;
import com.suncode.plugin.vendor.checker.enums.CheckMessageResponse;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.schemas.CheckDto;
import com.suncode.plugin.vendor.checker.schemas.EntityCheckResponse;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.services.CheckService;
import com.suncode.plugin.vendor.checker.utils.Builder;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.validator.ValidationContext;
import com.suncode.pwfl.workflow.form.validator.ValidatorDefinitionBuilder;
import com.suncode.pwfl.workflow.form.validator.annotation.Validator;
import com.suncode.pwfl.workflow.form.validator.error.ValidationErrors;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Validator
@ComponentsFormScript(value="scripts/dpwe/check-iban-valid-form.js")
public class ValidCheckIBAN {
    private static final Logger log = LoggerFactory.getLogger(ValidCheckIBAN.class);
    @Autowired
    private CheckService checkService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(ValidatorDefinitionBuilder builder) {
        ((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)((ValidatorDefinitionBuilder)builder.id("vendor.checker.check-iban.validator")).name("validator.vendor.checker.check-iban.name")).description("validator.vendor.checker.check-iban.desc")).category(new Category[]{Categories.VENDOR})).icon((Icon)SilkIconPack.XHTML_VALID)).parameter().id("nip_regon").name("vendor.checker.param.nip.name").description("vendor.checker.param.nip.desc").type((Type)Types.VARIABLE).create()).parameter().id("iban").name("vendor.checker.param.iban.name").description("vendor.checker.param.iban.desc").type((Type)Types.VARIABLE).create()).parameter().id("date").name("vendor.checker.param.date.name").description("vendor.checker.param.date.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("comment").name("vendor.checker.param.comment.name").description("vendor.checker.param.comment.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("addRequestId").name("vendor.checker.param.addRequestId.name").description("vendor.checker.param.addRequestId.desc").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("confirm").name("vendor.checker.param.confirm.name").description("vendor.checker.param.confirm.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("confirm-error").name("vendor.checker.param.confirm-error.name").description("vendor.checker.param.confirm-error.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create();
    }

    public void validate(@Param(value="nip_regon") Variable nipRegon, @Param(value="iban") Variable iban, @Param(value="date") Variable date, @Param(value="confirm") Boolean isConfirm, @Param(value="comment") Boolean isComment, @Param(value="confirm-error") Boolean isConfirmError, @Param(value="addRequestId") Boolean addRequestId, ValidationErrors errors, Translator translator, ValidationContext context, UserInfo userInfo) {
        try {
            String[] stringArray;
            String[] stringArray2;
            if (nipRegon.isArray()) {
                stringArray2 = (String[])nipRegon.getValue();
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = (String)nipRegon.getValue();
            }
            String[] nipsRegons = stringArray2;
            if (iban.isArray()) {
                stringArray = (String[])iban.getValue();
            } else {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = (String)iban.getValue();
            }
            String[] ibans = stringArray;
            LocalDate[] dates = new LocalDate[]{DateTime.now().toLocalDate()};
            if (date != null) {
                LocalDate[] localDateArray;
                if (date.isArray()) {
                    localDateArray = (LocalDate[])date.getValue();
                } else {
                    LocalDate[] localDateArray2 = new LocalDate[1];
                    localDateArray = localDateArray2;
                    localDateArray2[0] = (LocalDate)date.getValue();
                }
                dates = localDateArray;
            }
            List<ParamData> paramsInput = Builder.buildParamDatas(nipsRegons, ibans, dates);
            ArrayList<CheckDto> listCheckDto = new ArrayList<CheckDto>();
            Boolean isConnectionError = false;
            for (ParamData paramData : paramsInput) {
                try {
                    ResponseData<EntityCheckResponse> resultOnline = this.checkService.check(paramData, context.getProcessId());
                    listCheckDto.add(Builder.buildCheckDto(paramData, resultOnline));
                }
                catch (ExecutionException ee) {
                    listCheckDto.add(Builder.buildCheckDto(paramData, translator.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())})));
                    isConnectionError = true;
                }
            }
            StringBuilder commentMsg = new StringBuilder();
            StringBuilder globalErrorMgs = new StringBuilder();
            Boolean isGlobalMsg = false;
            Boolean isError = false;
            Boolean noErrors = true;
            Boolean noIBAN = false;
            HashMap<Long, String> tableError = new HashMap<Long, String>();
            Long row = 0L;
            for (CheckDto checkDto : listCheckDto) {
                String msg = checkDto.getMessage();
                String msgRequestId = "";
                if (row > 0L) {
                    commentMsg.append("<br>");
                }
                if (checkDto.getSuccess().booleanValue()) {
                    msg = translator.getMessage(checkDto.getCommentKey(), new Object[]{checkDto.getCommentValue(), checkDto.getCommentIban()});
                    if (addRequestId.booleanValue()) {
                        msgRequestId = " " + translator.getMessage("comment.requestID", new Object[]{checkDto.getReuestId()});
                    }
                }
                commentMsg.append(msg + msgRequestId);
                if (!checkDto.getSuccess().booleanValue() || checkDto.getMessage().equalsIgnoreCase(CheckMessageResponse.NO.getMsg()) || checkDto.getMessage().equalsIgnoreCase(CheckMessageResponse.NO_IBAN.getMsg())) {
                    if (checkDto.getMessage().equalsIgnoreCase(CheckMessageResponse.NO_IBAN.getMsg())) {
                        noIBAN = true;
                    } else {
                        noErrors = false;
                    }
                    if (row > 0L) {
                        globalErrorMgs.append("<br>");
                    }
                    if (!checkDto.getSuccess().booleanValue()) {
                        isError = true;
                    }
                    if (!(iban.isArray() || nipRegon.isArray() || date != null && date.isArray())) {
                        if (!(isConnectionError.booleanValue() || isConfirm.booleanValue() && !isError.booleanValue() || isConfirmError.booleanValue() && isError.booleanValue())) {
                            errors.add(msg, iban.getId());
                            if (date != null) {
                                errors.add(msg, date.getId());
                            }
                            errors.add(msg, nipRegon.getId());
                        }
                        globalErrorMgs.append(msg);
                    } else if (iban.isArray() && nipRegon.isArray() && (date == null || date.isArray())) {
                        tableError.put(row, translator.getMessage("valid.error.row", new Object[]{row + 1L}) + "\t" + msg);
                        globalErrorMgs.append(translator.getMessage("valid.error.row", new Object[]{row + 1L}) + "\t" + msg);
                        if (!checkDto.getMessage().equalsIgnoreCase(CheckMessageResponse.NO_IBAN.getMsg())) {
                            isGlobalMsg = true;
                        }
                    } else {
                        globalErrorMgs.append(translator.getMessage("valid.error.row", new Object[]{row + 1L}) + "\t" + msg);
                        if (!checkDto.getMessage().equalsIgnoreCase(CheckMessageResponse.NO_IBAN.getMsg())) {
                            isGlobalMsg = true;
                        }
                    }
                }
                Long l = row;
                Long l2 = row = Long.valueOf(row + 1L);
            }
            if (!noErrors.booleanValue()) {
                this.setErrors(nipRegon, iban, date, isConfirm, isConfirmError, errors, translator, isConnectionError, globalErrorMgs, isGlobalMsg, isError, tableError);
            } else if (noIBAN.booleanValue()) {
                errors.addConfirmation(globalErrorMgs.toString() + "<br><br>" + translator.getMessage("confirmation.question"), translator.getMessage("confirmation.title"));
            }
            if (isComment.booleanValue()) {
                this.setComment(commentMsg.toString(), context, userInfo != null ? userInfo.getUserName() : null);
            }
        }
        catch (Exception e) {
            log.error("Validator Error:\t" + context.getError().getMessage(), (Throwable)e);
            errors.add(translator.getMessage("valid.error") + "<br>" + e.getLocalizedMessage() + "<br>" + e.getMessage());
        }
    }

    private void setErrors(Variable nipRegon, Variable iban, Variable date, Boolean isConfirm, Boolean isConfirmError, ValidationErrors errors, Translator translator, Boolean isConnectionError, StringBuilder globalErrorMgs, Boolean isGlobalMsg, Boolean isError, Map<Long, String> tableError) {
        if (isConnectionError.booleanValue()) {
            errors.addConfirmation(globalErrorMgs.toString() + "<br><br>" + translator.getMessage("confirmation.question"), translator.getMessage("confirmation.title"));
        } else if (isConfirm.booleanValue() && !isError.booleanValue()) {
            errors.addConfirmation(globalErrorMgs.toString() + "<br><br>" + translator.getMessage("confirmation.question"), translator.getMessage("confirmation.title"));
        } else if (isConfirmError.booleanValue() && isError.booleanValue()) {
            errors.addConfirmation(globalErrorMgs.toString() + "<br><br>" + translator.getMessage("confirmation.question"), translator.getMessage("confirmation.title"));
        } else if (isGlobalMsg.booleanValue()) {
            for (Long index : tableError.keySet()) {
                errors.add(tableError.get(index), iban.getId(), index.intValue());
                if (date != null) {
                    errors.add(tableError.get(index), date.getId(), index.intValue());
                }
                errors.add(tableError.get(index), nipRegon.getId(), index.intValue());
            }
            errors.add(globalErrorMgs.toString());
        }
    }

    private void setComment(String msg, ValidationContext context, String userName) {
        Long commentId = this.commentService.createComment(Builder.buildComment(msg, (WorkflowContext)context, userName));
        log.debug("Created comment, id: " + commentId);
    }
}

