/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.utils;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateStringConverter {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final DateTimeFormatter REQUEST_DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm:ss");

    public static LocalDate[] stringToDate(String[] dates) {
        if (dates == null) {
            return null;
        }
        return (LocalDate[])Arrays.asList(dates).stream().map(date -> DateStringConverter.stringToDate(date)).toArray(LocalDate[]::new);
    }

    public static LocalDate stringToDate(String param) {
        if (StringUtils.isNotBlank((CharSequence)param)) {
            return LocalDate.parse((String)param, (DateTimeFormatter)DATE_FORMATTER);
        }
        return null;
    }

    public static LocalDateTime requestStringToDateTime(String param) {
        if (StringUtils.isNotBlank((CharSequence)param)) {
            return LocalDateTime.parse((String)param, (DateTimeFormatter)REQUEST_DATE_TIME_FORMATTER);
        }
        return null;
    }

    public static String dateTimeToStringPWE(LocalDateTime dateTime) {
        if (dateTime != null) {
            return dateTime.toString(DATE_TIME_FORMATTER);
        }
        return null;
    }
}

