/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.task;

import com.suncode.plugin.vendor.checker.services.DownloadService;
import com.suncode.plugin.vendor.checker.services.FlatFileHashService;
import com.suncode.plugin.vendor.checker.services.FlatFileIndexService;
import com.suncode.plugin.vendor.checker.services.JsonParser;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class DownloadFlatFileTask {
    @Autowired
    private FlatFileHashService flatFilelHashService;
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private JsonParser jsonParser;
    @Autowired
    private FlatFileIndexService ffIndexService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("vendor.checker.download-flat-file.task")).name("task.vendor.download-flat-file.name")).description("task.vendor.download-flat-file.desc")).parameter().id("deleteAfterDays").name("vendor.checker.param.delete-after-days.name").description("vendor.checker.param.delete-after-days.desc").type((Type)Types.INTEGER).create();
    }

    public String execute(@Param Long deleteAfterDays, ScheduledTaskInstanceInfo taskInfo, CancelationHandler cancelation, Logger taskLog) throws Exception {
        taskLog.debug((Object)("Start Task:\t" + taskInfo.getName()));
        LocalDate currentDate = LocalDate.now();
        LocalDate deleteOlderDate = currentDate.minusDays(deleteAfterDays.intValue() - 1);
        taskLog.debug((Object)("Delete data from database older than " + deleteOlderDate));
        this.flatFilelHashService.deleteOlderThan(deleteOlderDate);
        this.ffIndexService.deleteOlderThan(deleteOlderDate);
        if (this.ffIndexService.checkExist(currentDate).booleanValue()) {
            taskLog.debug((Object)"Data exist, don't need download");
            taskLog.debug((Object)("End task\t" + taskInfo.getName()));
            return "Data exist, don't need download";
        }
        taskLog.debug((Object)("Download flat file from " + currentDate));
        File archiveFile = this.downloadService.downloadFlatFile(currentDate);
        taskLog.debug((Object)("Downloaded file:\t" + archiveFile.getName()));
        File jsonFile = this.downloadService.unpackJsonFile(archiveFile);
        taskLog.debug((Object)("Delete archive:\t" + archiveFile.getName()));
        FileUtils.forceDelete((File)archiveFile);
        taskLog.debug((Object)"Save to database");
        Long dataSize = this.jsonParser.parseAndSave2DB(jsonFile);
        taskLog.debug((Object)("Delete flat file:\t" + jsonFile.getName()));
        FileUtils.forceDelete((File)jsonFile);
        taskLog.debug((Object)("Load data: " + dataSize));
        this.ffIndexService.save(currentDate);
        taskLog.debug((Object)("Save index table" + currentDate));
        taskLog.debug((Object)("End task\t" + taskInfo.getName()));
        return "saved  " + dataSize + " rows";
    }
}

