/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.task;

import com.suncode.plugin.vendor.checker.services.DownloadService;
import com.suncode.plugin.vendor.checker.services.FlatFileIndexService;
import com.suncode.plugin.vendor.checker.services.JsonParser;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class DownloadCurrentFlatFileTask {
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private FlatFileIndexService ffIndexService;
    @Autowired
    private JsonParser jsonParser;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("vendor.checker.download-current-flat-file.task")).name("task.vendor.download-current-flat-file.name")).description("task.vendor.download-current-flat-file.desc")).parameter().id("fileDate").name("vendor.checker.param.file-date.name").description("vendor.checker.param.file-date.desc").type((Type)Types.DATE).create();
    }

    public String execute(@Param(value="fileDate") LocalDate currentDate, ScheduledTaskInstanceInfo taskInfo, Logger taskLog) throws Exception {
        taskLog.debug((Object)("Start Task:\t" + taskInfo.getName()));
        if (this.ffIndexService.checkExist(currentDate).booleanValue()) {
            taskLog.debug((Object)"Data exist, don't need download");
            taskLog.debug((Object)("End task\t" + taskInfo.getName()));
            return "Data exist, don't need download";
        }
        taskLog.debug((Object)("Download FlatFle from " + currentDate));
        File archiveFile = this.downloadService.downloadFlatFile(currentDate);
        taskLog.debug((Object)("Downloaded file:\t" + archiveFile.getName()));
        File jsonFile = this.downloadService.unpackJsonFile(archiveFile);
        taskLog.debug((Object)("Delete archive:\t" + archiveFile.getName()));
        FileUtils.forceDelete((File)archiveFile);
        taskLog.debug((Object)"Save to  database");
        Long dataSize = this.jsonParser.parseAndSave2DB(jsonFile);
        taskLog.debug((Object)("Delete flatfile:\t" + jsonFile.getName()));
        FileUtils.forceDelete((File)jsonFile);
        taskLog.debug((Object)("Load data: " + dataSize));
        this.ffIndexService.save(currentDate);
        taskLog.debug((Object)("Save index table" + currentDate));
        taskLog.debug((Object)("End task\t" + taskInfo.getName()));
        return "saved  " + dataSize + " rows";
    }
}

