/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.vendor.checker.servlets;

import com.suncode.plugin.vendor.checker.enums.EntityHeaderParams;
import com.suncode.plugin.vendor.checker.enums.EntityParams;
import com.suncode.plugin.vendor.checker.enums.SystemParametersKey;
import com.suncode.plugin.vendor.checker.exception.ConnectionException;
import com.suncode.plugin.vendor.checker.schemas.CheckDto;
import com.suncode.plugin.vendor.checker.schemas.EntityItem;
import com.suncode.plugin.vendor.checker.schemas.ParamData;
import com.suncode.plugin.vendor.checker.schemas.ResponseData;
import com.suncode.plugin.vendor.checker.schemas.ResponseEntities;
import com.suncode.plugin.vendor.checker.schemas.ResponseEntityDto;
import com.suncode.plugin.vendor.checker.services.CheckService;
import com.suncode.plugin.vendor.checker.services.EntitiesInfoService;
import com.suncode.plugin.vendor.checker.utils.Builder;
import com.suncode.plugin.vendor.checker.utils.DateStringConverter;
import com.suncode.plugin.vendor.checker.utils.EntityTransformer;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class WebController {
    private static final Logger log = LoggerFactory.getLogger(WebController.class);
    @Autowired
    private CheckService checkService;
    @Autowired
    private EntitiesInfoService entityInfoService;

    @RequestMapping(value={"check/iban"}, method={RequestMethod.POST})
    @ResponseBody
    public CheckDto checkIBAN(@RequestParam(value="nip") String nip, @RequestParam(value="iban") String iban, @RequestParam(value="date") String date, @RequestParam(value="processid") String processId) {
        ParamData paramData = new ParamData();
        paramData.setNrb(iban);
        paramData.setDate(date);
        paramData.setNip(nip);
        try {
            return Builder.buildCheckDto(paramData, this.checkService.check(paramData, processId));
        }
        catch (ExecutionException e) {
            CheckDto checktDto = new CheckDto();
            Translator t = Translators.get((String)"com.suncode.plugin-vendor.checker");
            checktDto.setMessage(t.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())}));
            checktDto.setSuccess(false);
            return checktDto;
        }
    }

    @RequestMapping(value={"check/ibans"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<CheckDto>> checkIBANS(@RequestParam(value="nips[]") String[] nips, @RequestParam(value="ibans[]") String[] ibans, @RequestParam(value="dates[]") String[] dates, @RequestParam(value="processid") String processId) {
        ResponseData<List<CheckDto>> result = new ResponseData<List<CheckDto>>();
        List<ParamData> paramsInput = Builder.buildParamDatas(nips, ibans, dates);
        ArrayList listCheckDto = new ArrayList();
        paramsInput.stream().forEach(paramData -> {
            try {
                listCheckDto.add(Builder.buildCheckDto(paramData, this.checkService.check((ParamData)paramData, processId)));
            }
            catch (ExecutionException e) {
                Translator t = Translators.get((String)"com.suncode.plugin-vendor.checker");
                listCheckDto.add(Builder.buildCheckDto(paramData, t.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())})));
            }
        });
        result.setData(listCheckDto);
        result.setSuccess(true);
        return result;
    }

    @RequestMapping(value={"entity"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseData<Map<String, Object>> getEntityInfo(@RequestParam String nipNrb, @RequestParam(required=false) String date, @RequestParam String searchType) {
        ResponseData<Map<String, Object>> result = new ResponseData<Map<String, Object>>();
        ParamData param = Builder.buildParamData(nipNrb, DateStringConverter.stringToDate(date), searchType);
        try {
            ResponseEntities responseEntity = this.entityInfoService.getEntities(param);
            String status = responseEntity.getSuccess() != false ? "OK" : responseEntity.getMessage();
            log.debug("Status: " + status);
            if (responseEntity.getSuccess().booleanValue()) {
                result.setData(this.convertEntityToMap(responseEntity));
            }
            result.setSuccess(responseEntity.getSuccess());
            result.setMessage(status);
        }
        catch (ConnectionException ce) {
            Translator translator = Translators.get((String)"com.suncode.plugin-vendor.checker");
            log.error("Brak po\u0142\u0105czenia z Internetem \u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF", (Throwable)ce);
            result.setMessage(translator.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())}));
        }
        return result;
    }

    @RequestMapping(value={"entities"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData<List<Map<String, String>>> getEntitiesInfo(@RequestParam(value="nipsOrNrbs[]") String[] nipsOrNrbs, @RequestParam(value="dates[]", required=false) String[] dates, @RequestParam String searchType, @RequestParam(value="entityParamsName[]") String[] entityParamsName) {
        ResponseData<List<Map<String, String>>> result = new ResponseData<List<Map<String, String>>>();
        LocalDate[] localDates = DateStringConverter.stringToDate(dates);
        List<ParamData> paramsData = Builder.buildMultiParamData(nipsOrNrbs, localDates, searchType);
        try {
            ResponseEntityDto responseEntityDto = this.entityInfoService.getResponseEntityDto(paramsData);
            result.setData(this.convertEntityToListMap(responseEntityDto.getEntityItemMap(), nipsOrNrbs, localDates, entityParamsName));
            result.setSuccess(responseEntityDto.getSuccess());
            result.setMessage(responseEntityDto.getStatus());
        }
        catch (ConnectionException ce) {
            Translator translator = Translators.get((String)"com.suncode.plugin-vendor.checker");
            log.error("Brak po\u0142\u0105czenia z Internetem \u2013 kontrahent nie zosta\u0142 zweryfikowany w bazie MF", (Throwable)ce);
            result.setMessage(translator.getMessage("error.connection", new Object[]{SystemProperties.getString((String)SystemParametersKey.SERWER_HOST.getName())}));
        }
        return result;
    }

    private List<Map<String, String>> convertEntityToListMap(Map<String, EntityItem> entityItemMap, String[] orgNipsOrNrbs, LocalDate[] dates, String[] entityParamsName) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (int index = 0; index < orgNipsOrNrbs.length; ++index) {
            String orgNipOrNrb = orgNipsOrNrbs[index];
            HashMap<String, String> row = new HashMap<String, String>();
            String value = "";
            for (String entityParam : entityParamsName) {
                if (orgNipOrNrb != null) {
                    String nipOrNrb = orgNipOrNrb.replaceAll("\\D", "");
                    String date = Builder.readDate(index, dates).toString();
                    String key = nipOrNrb + "##" + date;
                    if (StringUtils.isNotBlank((CharSequence)nipOrNrb) && entityItemMap.containsKey(key)) {
                        EntityHeaderParams entityParamType = EntityHeaderParams.valueOf(entityParam);
                        EntityItem entityItem = entityItemMap.get(key);
                        if (entityParamType == EntityHeaderParams.REQUEST_ID) {
                            value = entityItem.getRequestId();
                        } else if (entityParamType == EntityHeaderParams.REQUEST_DATETIME) {
                            value = entityItem.getRequestDateTime();
                        } else if (entityParamType == EntityHeaderParams.ERROR_MESSEGE) {
                            value = entityItem.getErrorMessege();
                        } else if (entityItem.getSubject() != null) {
                            Object obj = EntityTransformer.readParam(entityItem.getSubject(), EntityParams.valueOf(entityParam), true);
                            value = obj == null ? "" : obj.toString();
                        }
                    }
                }
                row.put(entityParam, value);
            }
            result.add(row);
        }
        return result;
    }

    private Map<String, Object> convertEntityToMap(ResponseEntities responseEntity) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EntityParams entityParam : EntityParams.values()) {
            Object obj = null;
            if (entityParam == EntityParams.REQUEST_ID) {
                obj = responseEntity.getRequestId();
            } else if (entityParam == EntityParams.REQUEST_DATETIME) {
                LocalDateTime dateTime = DateStringConverter.requestStringToDateTime(responseEntity.getRequestDateTime());
                obj = DateStringConverter.dateTimeToStringPWE(dateTime);
            } else {
                List entities = responseEntity.getEntities().stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (!entities.isEmpty()) {
                    obj = EntityTransformer.readParam(responseEntity.getEntities().get(0), entityParam, true);
                }
            }
            result.put(entityParam.name(), obj);
        }
        return result;
    }
}

